% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-data-frame.R, R/handle-slice.R
\name{wk_handle_slice.data.frame}
\alias{wk_handle_slice.data.frame}
\alias{wk_handle_slice}
\alias{wk_handle_slice.default}
\title{Handle specific regions of objects}
\usage{
\method{wk_handle_slice}{data.frame}(handleable, handler, from = NULL, to = NULL, ...)

wk_handle_slice(
  handleable,
  handler = wk_writer(handleable),
  from = NULL,
  to = NULL,
  ...
)

\method{wk_handle_slice}{default}(
  handleable,
  handler = wk_writer(handleable),
  from = NULL,
  to = NULL,
  ...
)
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{handler}{A \link[=wk_handle]{wk_handler} object.}

\item{from}{1-based index of the feature to start from}

\item{to}{1-based index of the feature to end at}

\item{...}{Passed to the \code{\link[=wk_handle]{wk_handle()}} method.}
}
\value{
A subset of \code{handleable}
}
\description{
Handle specific regions of objects
}
\examples{
wk_handle_slice(xy(1:5, 1:5), wkt_writer(), from = 3, to = 5)
wk_handle_slice(
  data.frame(let = letters[1:5], geom = xy(1:5, 1:5)),
  wkt_writer(),
  from = 3, to = 5
)

}
