# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

read_connection_ <- function(con, chunk_size = 64 * 1024L) {
    .Call('xml2_read_connection_', PACKAGE = 'xml2', con, chunk_size)
}

xml_parse_options <- function() {
    .Call('xml2_xml_parse_options', PACKAGE = 'xml2')
}

doc_parse_file <- function(path, encoding = "", as_html = FALSE, options = 0L) {
    .Call('xml2_doc_parse_file', PACKAGE = 'xml2', path, encoding, as_html, options)
}

doc_parse_raw <- function(x, encoding, base_url = "", as_html = FALSE, options = 0L) {
    .Call('xml2_doc_parse_raw', PACKAGE = 'xml2', x, encoding, base_url, as_html, options)
}

doc_root <- function(x) {
    .Call('xml2_doc_root', PACKAGE = 'xml2', x)
}

doc_has_root <- function(x) {
    .Call('xml2_doc_has_root', PACKAGE = 'xml2', x)
}

doc_url <- function(x) {
    .Call('xml2_doc_url', PACKAGE = 'xml2', x)
}

doc_new <- function(version, encoding = "UTF-8") {
    .Call('xml2_doc_new', PACKAGE = 'xml2', version, encoding)
}

doc_set_root <- function(doc, root) {
    .Call('xml2_doc_set_root', PACKAGE = 'xml2', doc, root)
}

libxml2_version <- function() {
    .Call('xml2_libxml2_version', PACKAGE = 'xml2')
}

unique_ns <- function(ns) {
    .Call('xml2_unique_ns', PACKAGE = 'xml2', ns)
}

doc_namespaces <- function(doc) {
    .Call('xml2_doc_namespaces', PACKAGE = 'xml2', doc)
}

ns_lookup_uri <- function(doc, node, uri) {
    .Call('xml2_ns_lookup_uri', PACKAGE = 'xml2', doc, node, uri)
}

ns_lookup <- function(doc, node, prefix) {
    .Call('xml2_ns_lookup', PACKAGE = 'xml2', doc, node, prefix)
}

node_name <- function(node, nsMap) {
    .Call('xml2_node_name', PACKAGE = 'xml2', node, nsMap)
}

node_set_name <- function(node, value) {
    invisible(.Call('xml2_node_set_name', PACKAGE = 'xml2', node, value))
}

node_text <- function(node) {
    .Call('xml2_node_text', PACKAGE = 'xml2', node)
}

node_attr <- function(node, name, missing, nsMap) {
    .Call('xml2_node_attr', PACKAGE = 'xml2', node, name, missing, nsMap)
}

node_attrs <- function(node_, nsMap) {
    .Call('xml2_node_attrs', PACKAGE = 'xml2', node_, nsMap)
}

node_set_attr <- function(node_, name, value, nsMap) {
    invisible(.Call('xml2_node_set_attr', PACKAGE = 'xml2', node_, name, value, nsMap))
}

node_children <- function(node, onlyNode = TRUE) {
    .Call('xml2_node_children', PACKAGE = 'xml2', node, onlyNode)
}

node_length <- function(node, onlyNode = TRUE) {
    .Call('xml2_node_length', PACKAGE = 'xml2', node, onlyNode)
}

node_parents <- function(node) {
    .Call('xml2_node_parents', PACKAGE = 'xml2', node)
}

node_siblings <- function(node, onlyNode = TRUE) {
    .Call('xml2_node_siblings', PACKAGE = 'xml2', node, onlyNode)
}

node_parent <- function(n) {
    .Call('xml2_node_parent', PACKAGE = 'xml2', n)
}

node_path <- function(n) {
    .Call('xml2_node_path', PACKAGE = 'xml2', n)
}

nodes_duplicated <- function(nodes) {
    .Call('xml2_nodes_duplicated', PACKAGE = 'xml2', nodes)
}

node_type <- function(node) {
    .Call('xml2_node_type', PACKAGE = 'xml2', node)
}

node_copy <- function(node) {
    .Call('xml2_node_copy', PACKAGE = 'xml2', node)
}

node_set_content <- function(node, content) {
    invisible(.Call('xml2_node_set_content', PACKAGE = 'xml2', node, content))
}

node_append_content <- function(node, content) {
    invisible(.Call('xml2_node_append_content', PACKAGE = 'xml2', node, content))
}

node_append_child <- function(parent, cur) {
    .Call('xml2_node_append_child', PACKAGE = 'xml2', parent, cur)
}

node_prepend_sibling <- function(cur, elem) {
    .Call('xml2_node_prepend_sibling', PACKAGE = 'xml2', cur, elem)
}

node_append_sibling <- function(cur, elem) {
    .Call('xml2_node_append_sibling', PACKAGE = 'xml2', cur, elem)
}

node_replace <- function(old, cur) {
    .Call('xml2_node_replace', PACKAGE = 'xml2', old, cur)
}

node_remove <- function(cur, free) {
    invisible(.Call('xml2_node_remove', PACKAGE = 'xml2', cur, free))
}

node_new <- function(name) {
    .Call('xml2_node_new', PACKAGE = 'xml2', name)
}

node_cdata_new <- function(doc, content) {
    .Call('xml2_node_cdata_new', PACKAGE = 'xml2', doc, content)
}

node_comment_new <- function(content) {
    .Call('xml2_node_comment_new', PACKAGE = 'xml2', content)
}

node_new_ns <- function(name, ns) {
    .Call('xml2_node_new_ns', PACKAGE = 'xml2', name, ns)
}

node_null <- function() {
    .Call('xml2_node_null', PACKAGE = 'xml2')
}

node_set_namespace_uri <- function(doc, node, uri) {
    invisible(.Call('xml2_node_set_namespace_uri', PACKAGE = 'xml2', doc, node, uri))
}

node_set_namespace_prefix <- function(doc, node, prefix) {
    invisible(.Call('xml2_node_set_namespace_prefix', PACKAGE = 'xml2', doc, node, prefix))
}

node_new_dtd <- function(doc, name = "", eid = "", sid = "") {
    invisible(.Call('xml2_node_new_dtd', PACKAGE = 'xml2', doc, name, eid, sid))
}

xml_save_options <- function() {
    .Call('xml2_xml_save_options', PACKAGE = 'xml2')
}

doc_write_file <- function(x, path, encoding = "UTF-8", options = 1L) {
    invisible(.Call('xml2_doc_write_file', PACKAGE = 'xml2', x, path, encoding, options))
}

doc_write_connection <- function(x, connection, encoding = "UTF-8", options = 1L) {
    invisible(.Call('xml2_doc_write_connection', PACKAGE = 'xml2', x, connection, encoding, options))
}

doc_write_character <- function(x, encoding = "UTF-8", options = 1L) {
    .Call('xml2_doc_write_character', PACKAGE = 'xml2', x, encoding, options)
}

node_write_file <- function(x, path, encoding = "UTF-8", options = 1L) {
    invisible(.Call('xml2_node_write_file', PACKAGE = 'xml2', x, path, encoding, options))
}

node_write_connection <- function(x, connection, encoding = "UTF-8", options = 1L) {
    invisible(.Call('xml2_node_write_connection', PACKAGE = 'xml2', x, connection, encoding, options))
}

node_write_character <- function(x, encoding = "UTF-8", options = 1L) {
    .Call('xml2_node_write_character', PACKAGE = 'xml2', x, encoding, options)
}

doc_validate <- function(doc, schema) {
    .Call('xml2_doc_validate', PACKAGE = 'xml2', doc, schema)
}

#' Convert between relative and absolute urls.
#'
#' @param x A character vector of urls relative to that base
#' @param base A string giving a base url.
#' @return A character vector of urls
#' @seealso \code{\link{xml_url}} to retrieve the URL associated with a document
#' @export
#' @examples
#' url_absolute(c(".", "..", "/", "/x"), "http://hadley.nz/a/b/c/d")
#'
#' url_relative("http://hadley.nz/a/c", "http://hadley.nz")
#' url_relative("http://hadley.nz/a/c", "http://hadley.nz/")
#' url_relative("http://hadley.nz/a/c", "http://hadley.nz/a/b")
#' url_relative("http://hadley.nz/a/c", "http://hadley.nz/a/b/")
url_absolute <- function(x, base) {
    .Call('xml2_url_absolute', PACKAGE = 'xml2', x, base)
}

#' @export
#' @rdname url_absolute
url_relative <- function(x, base) {
    .Call('xml2_url_relative', PACKAGE = 'xml2', x, base)
}

#' Parse a url into its component pieces.
#'
#' @param x A character vector of urls.
#' @return A dataframe with one row for each element of \code{x} and
#'   columns: scheme, server, port, user, path, query, fragment.
#' @export
#' @examples
#' url_parse("http://had.co.nz/")
#' url_parse("http://had.co.nz:1234/")
#' url_parse("http://had.co.nz:1234/?a=1&b=2")
#' url_parse("http://had.co.nz:1234/?a=1&b=2#def")
url_parse <- function(x) {
    .Call('xml2_url_parse', PACKAGE = 'xml2', x)
}

#' Escape and unescape urls.
#'
#' @param x A character vector of urls.
#' @param reserved A string containing additional characters to avoid escaping.
#' @export
#' @examples
#' url_escape("a b c")
#' url_escape("a b c", "")
#'
#' url_unescape("a%20b%2fc")
#' url_unescape("%C2%B5")
url_escape <- function(x, reserved = "") {
    .Call('xml2_url_escape', PACKAGE = 'xml2', x, reserved)
}

#' @export
#' @rdname url_escape
url_unescape <- function(x) {
    .Call('xml2_url_unescape', PACKAGE = 'xml2', x)
}

xpath_search <- function(node, doc, xpath, nsMap, num_results) {
    .Call('xml2_xpath_search', PACKAGE = 'xml2', node, doc, xpath, nsMap, num_results)
}

