"orient.pdb" <-
function (pdb, atom.subset = NULL, verbose = TRUE) {
  
    if (missing(pdb)) {
        stop("pdb.orient: must supply 'pdb' object, e.g. from 'read.pdb'")
    }

    if(is.list(pdb)) { xyz <- pdb$xyz
    } else {
      if (!is.vector(pdb)) {
        stop("pdb.orient: input 'pdb' should NOT be a matrix")
      }
      xyz <- pdb
    }
    xyz <- matrix( xyz, ncol=3, byrow=TRUE )   

    if (is.null(atom.subset)) atom.subset <- c(1:nrow(xyz))
    if (length(atom.subset) > nrow(xyz)) {
        stop("pdb.orient: there are more 'atom.subset' inds than there atoms")
    }
    
    S <- var(xyz[atom.subset, ])
    mean <- apply(xyz[atom.subset, ], 2, mean)
    prj <- eigen(S, symmetric = TRUE)
    z <- sweep(xyz, 2, mean) %*% (prj$vectors)
    if (verbose) {
        cat("Dimensions:", "\n")
        cat(" x  min=", round(min(z[, 1]), 3), "   max=", round(max(z[, 
            1]), 3), "   range=", round(max(z[, 1]) - min(z[, 
            1]), 3), "\n")
        cat(" y  min=", round(min(z[, 2]), 3), "   max=", round(max(z[, 
            2]), 3), "   range=", round(max(z[, 2]) - min(z[, 
            1]), 3), "\n")
        cat(" z  min=", round(min(z[, 3]), 3), "   max=", round(max(z[, 
            3]), 3), "   range=", round(max(z[, 3]) - min(z[, 
            1]), 3), "\n")
    }
    z <- round(as.vector(t(z)),3)
#    if (!is.null(file)) write.pdb(pdb, xyz = z, file = file)
    return(z)
}

