"dssp" <-
function (pdb, exepath = "", resno=TRUE) {
    infile <- tempfile()
    outfile <- tempfile()
    write.pdb(pdb, file = infile)
    system(paste(exepath, "dssp -c ", infile, " ",
                 outfile, sep = ""), ignore.stderr = TRUE)
    raw.lines <- readLines(outfile)
    unlink(c(infile, outfile))
    type <- substring(raw.lines, 1, 3)
    raw.lines <- raw.lines[-(1:which(type == "  #"))]
    cha <- substring(raw.lines, 12, 12)
    sse <- substring(raw.lines, 17, 17)
    phi <- as.numeric(substring(raw.lines, 96, 101))
    psi <- as.numeric(substring(raw.lines, 102, 107))
    acc <- as.numeric(substring(raw.lines, 35, 38))
    
    if(resno) {
      ##res.ind <- as.numeric(substring(raw.lines, 1, 5))
      res.num  <- as.numeric(substring(raw.lines, 6, 10))
      h.s <- bounds(res.num[which(sse == "H")])
      g.s <- bounds(res.num[which(sse == "G")])
      e.s <- bounds(res.num[which(sse == "E")])
      t.s <- bounds(res.num[which(sse == "T")])
    } else {
      h.s <- bounds(which(sse == "H"))
      g.s <- bounds(which(sse == "G"))
      e.s <- bounds(which(sse == "E"))
      t.s <- bounds(which(sse == "T"))
    }
    
    helix = list(start=NULL, end=NULL, length=NULL, chain=NULL)
    sheet = helix; turn = helix

    if(length(h.s)>1) {
      if(is.null(nrow(h.s)))
        h.s <- as.matrix(t(h.s))
      helix$start  = c(helix$start,h.s[, "start"])
      helix$end    = c(helix$end, h.s[, "end"])
      helix$length = c(helix$length, h.s[, "length"])
      helix$chain  = c(helix$chain, cha[h.s[, "start"]])
    }
    if(length(g.s)>1) {
      if(is.null(nrow(g.s)))
        g.s <- as.matrix(t(g.s))
      helix$start  = c(helix$start,g.s[, "start"])
      helix$end    = c(helix$end, g.s[, "end"])
      helix$length = c(helix$length, g.s[, "length"])
      helix$chain  = c(helix$chain, cha[g.s[, "start"]])
    }
    if(length(e.s)>1) {
      if(is.null(nrow(e.s)))
        e.s <- as.matrix(t(e.s))
      sheet$start  = c(sheet$start,e.s[, "start"])
      sheet$end    = c(sheet$end, e.s[, "end"])
      sheet$length = c(sheet$length, e.s[, "length"])
      sheet$chain  = c(sheet$chain, cha[e.s[, "start"]])
    }
    if(length(t.s)>1) {
      if(is.null(nrow(t.s)))
        t.s <- as.matrix(t(t.s))
      turn$start  = c(turn$start,t.s[, "start"])
      turn$end    = c(turn$end, t.s[, "end"])
      turn$length = c(turn$length, t.s[, "length"])
      turn$chain  = c(turn$chain, cha[t.s[, "start"]])
    }

    out <- list(helix = helix, sheet = sheet,
                turn = turn, phi = phi, psi = psi, acc = acc)
}
