% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene2cellcomponent.R
\name{gene2cellcomponent}
\alias{gene2cellcomponent}
\title{Query for given gene(s) and generates an \code{DataGeNET.RDF}}
\usage{
gene2cellcomponent(gene, verbose = FALSE, warnings = TRUE)
}
\arguments{
\item{gene}{NCBI gene ID}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get a
on-time log from the function.}

\item{warnings}{By default \code{TRUE}. Change it to \code{FALSE} to don't see
the warnings.}
}
\value{
An object of class \code{DataGeNET.RDF}
}
\description{
Given a NCBI gene identifier, retrieves the GO (Gene Ontology) information
related to the cellular location of the gene product and creates an object
of type \code{DataGeNET.RDF}.
}
\examples{
gene2cc <- gene2cellcomponent( gene = 1588 )
}
