#!/bin/sh
#
# This script used as callhandler in raccess.conf uses vboxputty to notify
# You by phonecall if vbox received a new message.
# The user running the vbox3 needs to be allowed to use vboxputty with sudo
# add a line similar to the following to /etc/sudoers
#
# <user>	<hostname>=NOPASSWD: /usr/sbin/vboxputty
#
# Add a section for the phonenumber $NOTIFY in the user's vboxrc similar to
# this
#
# [CALLERID]
# 017000000	notify	Notify
#
# [NOTIFY]
# *	*	donothing.tcl	1	4	4
#
# use the 2nd numeric value to adjust the number of rings before giveup.

NOTIFY=017000000

FILE=$1
WHO=$2
ID=$3
USER=$4

# this does the standard delivery by vboxmail                
|BIN_DIR|/vboxmail "$FILE" "$WHO" "$ID" "$USER"

exec /usr/bin/sudo /usr/sbin/vboxputty -d /dev/ttyI2 -c $NOTIFY -x FULL
