/*
 * This game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 * 
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>

#include "tile_enums.h"
#include "game_config.h"
#include "map.h"
#include "track.h"
#include "tile_enums.h"
#include "graphics.h"
#include "car.h"
#include "dust.h"
#include "game_data.h"
#include "map_objects/all.h"
#include "fonts.h"
#include "camera.h"
#include "info_gfx.h"
#include "texture.h"
#include "debug.h"
#include "object_3d.h"
#include "track.h"
#include "height_map.h"
#include "draw_track.h"

#define MAP_WIDTH 40
#define MAP_HEIGHT 40
#define TILE_WIDTH Config::tile_size
#define TILE_HEIGHT Config::tile_size

void DrawTrack::draw()
{
	draw_track( 0, 0 );
}



void DrawTrack::draw_split()
{

}



void DrawTrack::draw_track( int center_x, int center_y )
{
	RaceDebug::print("DrawTrack: draw_track entered", 1 );	
	RaceDebug::print("DrawTrack: draw_track(): set camera position & look at", 1 );

	float cx, cy, cz;
	
	std::vector<Car*>::iterator it;

	for(it = GameData::cars.begin();
		 it != GameData::cars.end();
		 it++ )
	{
		if( (*it)->is_player() && (*it)->id == 0 )
		{
			cx = (*it)->x;
			cy = (*it)->y;
			cz = (*it)->z;
			
			(*it)->camera.look_at(cx,cy,cz);
			break;
		}
	}
	
	// draw terrain
	// ---------------------
	// the terrain mesh is split into 16 parts of which 9 are drawn, so we
	// don't need to send  so many vertices to opengl.


	RaceDebug::print( "DrawTrack: draw_track(): terrain...", 1 );
	
	Track::terrain_texture->bind();
	RaceDebug::print( "\tDrawTrack: draw_track(): call track display lists", 1 );
	
	int mx = ((cx/40.0f)*3)+0.5f; // the piece of the mesh the car is on
	int my = ((cy/40.0f)*3)+0.5f; // the piece of the mesh the car is on
	
	// x: the visible parts of the terrain
	// C: the car
	// .-------------------.
	// |  x |  x | x  |    |
	// |----|----|----|----|
	// |  x | Cx | x  |    |
	// |----|----|----|----|
	// |  x |  x | x  |    |
	// |----|----|----|----|
	// |    |    |    |    |
	// '-------------------'
	
	// TODO: use a lod and get rid of this crap
	if( mx < 1 ) mx = 1;
	if( mx > 2 ) mx = 2;
	if( my < 1 ) my = 1;
	if( my > 2 ) my = 2;
	
	char lists_to_call[9] = 
	{
		my*4+mx-1,
		my*4+mx,
		my*4+mx+1,
		
		(my+1)*4+mx-1,
		(my+1)*4+mx,
		(my+1)*4+mx+1,
		
		(my-1)*4+mx-1,
		(my-1)*4+mx,
		(my-1)*4+mx+1
	};

	
	for( int i=0; i<9; i++ )
	{
		glCallList( Track::terrain_display_list + lists_to_call[i] );
	}
	
	RaceDebug::print( "DrawTrack: draw_track(): terrain -- done", 1 );
	
	// draw road
	// ---------------------
	// the road is, like the terrain, split into 16 parts. (9 are drawn) One big texture is
	// used as the road (gets a bit blurry but I don't know of a better solution)

	glDisable( GL_DEPTH_TEST );
	
	glPushMatrix();
		glTranslatef( 0.0f, 0.0f, 0.025f ); // lift up from terrain
		RaceDebug::print( "DrawTrack: draw_track(): bind texture", 1 );
		Track::road_texture->bind();
		RaceDebug::print( "DrawTrack: draw_track(): call track display list", 1 );
//		for( int i=0; i<9; i++ )
//		{
//			glCallList( Track::road_display_list[lists_to_call[i]] );
//		}
		glCallList( Track::road_display_list );
	glPopMatrix();

	glEnable( GL_DEPTH_TEST );

	// draw cars
	// ---------------------
	
	RaceDebug::print("DrawTrack: drawing cars", 1 );
	for( it = GameData::cars.begin(); it != GameData::cars.end(); it++)
		(*it)->show( center_x, center_y );
	RaceDebug::print("DrawTrack: drawing cars -- done", 1 );
	
	
	// misc other drawing
	// ----------------------
	draw_map_objects();
	draw_water();
	draw_dust();

	RaceDebug::print("DrawTrack: 3D part done... going 2d", 1 );
	InfoGfx::draw(); // speed & other eyecandyish stuff.
	RaceDebug::print("DrawTrack: done", 1 );
}



void DrawTrack::draw_water()
{
	RaceDebug::print("DrawTrack: drawing water", 1 );
	
/*	int time_elapsed = CL_System::get_time() - water_height_timer;
	water_height_timer = CL_System::get_time();
	water_height_sin_counter += 0.125f * time_elapsed/100.0f;
*/	
	float wz = 0.3f; // water z
	float wtc_0 = 0.0f; // + sin(water_height_sin_counter)/12;    // water tex coords
	float wtc_1 = 10.0f; // + sin(water_height_sin_counter)/12;   // water tex coords
	
	glColor4f( 1.0f, 1.0f, 1.0f, 0.45f );
	
	Track::water->bind();
	
	glBegin( GL_QUADS );
		glTexCoord2f( wtc_1, wtc_1 );
		 glVertex3f( 40.0f, 40.0f, wz );
		glTexCoord2f( wtc_0, wtc_1 );
		 glVertex3f( 0.0f, 40.0f, wz );
		glTexCoord2f( wtc_0, wtc_0 );
		 glVertex3f( 0.0f, 0.0f, wz );
		glTexCoord2f( wtc_1, wtc_0 );
		 glVertex3f( 40.0f, 0.0f, wz );
	glEnd();
	
	glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );
	
	RaceDebug::print("DrawTrack: drawing water -- done", 1 );
}

void DrawTrack::draw_dust()
{
	RaceDebug::print("DrawTrack: drawing dust", 1 );
	
	glBlendFunc( GL_SRC_ALPHA, GL_ONE );
	
	std::vector<Dust>::iterator it;
	for( it = GameData::dust_list.begin(); it != GameData::dust_list.end(); it++)
		(*it).show();
	
	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
	
//	glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );
	
	RaceDebug::print("DrawTrack: drawing dust -- done", 1 );
}

void DrawTrack::draw_map_objects()
{
	int x, y;

	for ( y=MAP_HEIGHT; y > 0; y-- )
	{
		for ( x=MAP_WIDTH; x > 0; x--)
		{
			Items item = Items( Track::track->get_data(x,y));

			float z = HeightMap::get_height_tile_coord(x,y);

			Fence::draw( x, y, z, Items(item) );
			House::draw( x, y, z, Items(item) );
			Tree::draw(  x, y, z, Items(item) );
//			Bridge::draw( scr_x, scr_y, Items(item) );
//			Ramp::draw( scr_x, scr_y, item );
//			Pit::draw( scr_x, scr_y, Items(item) );
//			WaterObject::draw( scr_x, scr_y, Items(item) );
		}
	}
}

void DrawTrack::draw_edges()
{	
/*	glPushMatrix();
	//glLoadIdentity();

	Track::terrain_texture->bind();
	
	// left
	Gfx::TrackGfx->map_edge->draw();
	
	// right
	glPushMatrix();
	glTranslatef(40.0f, 0.0f, 0.0f);
	glScalef(-1.0f, 1.0f, 1.0f);
	Gfx::TrackGfx->map_edge->draw();
	glPopMatrix();

	// top
	glPushMatrix();
	//glRotatef(90.0f, 0.0f, 0.0f, 1.0f); // -90 ?
	glTranslatef(0.0f, 40.0f, 0.0f);
	Gfx::TrackGfx->map_edge_td->draw();
	glPopMatrix();

	// down
	glPushMatrix();
	// glRotatef(90.0f, 0.0f, 0.0f, -1.0f); // -90 ?	
	glScalef(1.0f, -1.0f, 1.0f);
	Gfx::TrackGfx->map_edge_td->draw();
	glPopMatrix();

	glPopMatrix();
*/
}
