
#include "face.h"

Face::Face( double r0, double g0, double b0,
			double r1, double g1, double b1,
			double r2, double g2, double b2,
			double nx0, double ny0, double nz0,
			double nx1, double ny1, double nz1,
			double nx2, double ny2, double nz2,
			double u0, double u1, double u2,
			double v0, double v1, double v2,
			double x0, double y0, double z0,
			double x1, double y1, double z1,
			double x2, double y2, double z2,
			bool shade_type, bool has_tex )
{
	this->shade_type = true;  // smooth by default
	this->has_tex    = false; // no uv tex coords

	// color
	r[0] = r0; g[0] = g0; b[0] = b0;
	r[1] = r1; g[1] = g1; b[1] = b1;
	r[2] = r2; g[2] = g2; b[2] = b2;

	// normals
	nx[0] = nx0; ny[0] = ny0; nz[0] = nz0;
	ny[1] = nx1; ny[1] = ny1; nz[1] = nz1;
	nz[2] = nx2; ny[2] = ny2; nz[2] = nz2;

	// uv texture coordinates
	u[0] = u0; u[1] = u1; u[2] = u2;
	v[0] = v0; v[1] = v1; v[2] = v2;

	// vertices
	x[0] = x0; y[0] = y0; z[0] = z0;
	x[1] = x1; y[1] = y1; z[1] = z1;
	x[2] = x2; y[2] = y2; z[2] = z2;

	this->shade_type = shade_type;
	this->has_tex = has_tex;
}
