/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/


#include <ClanLib/core.h>
#include <ClanLib/display.h>

#include "car_config.h"
#include "game_config.h"
#include "config.h"
#include "debug.h"
#include "track_list_entry.h"

CarConfig* Config::cc = new CarConfig();

std::vector<std::string> Config::names;

float Config::water_level = 0.3f;
float Config::difficulty_level = 1.1f;
short Config::race_length = 2;

short Config::screen_width = 800;
short Config::screen_height = 600;

short Config::num_players = 0;
short Config::num_ai = 3;
short Config::num_cars = 1;
short Config::save_texture = 1;

int Config::random_theme = 0;

bool Config::mirror_fill = 0;
int Config::terrain_resolution = 60;
char Config::screen_resolution = 0;

bool Config::big_road_texture = 1;
bool Config::abandon_season = 0;

// KEYS

CL_Key Config::one_player_key_gas = 0;
CL_Key Config::one_player_key_brakes = 0;
CL_Key Config::one_player_key_left = 0;
CL_Key Config::one_player_key_right = 0;

// THEME VARIABLES

float Config::road_speed = 0;
float Config::terrain_speed = 0;
float Config::skid_speed_decrease = 0;
float Config::no_gas_speed_decrease = 0;
float Config::brakes_speed_decrease = 0;
float Config::update_dir_timer = 0;
char Config::tyre_grip = 0;

CL_String Config::theme_path = "";
CL_String Config::theme_name = "";

int Config::selected_theme = 0;

bool Config::in_editor = false;

std::vector<std::string> Config::selected_tracks;

// SOUND

float Config::engine_sound_radius = 7.0f;
int Config::sfx_on = 0;
int Config::music_on = 0;

// TRACK
char Config::tile_size = 25;
char Config::map_tiles_x = 40;
char Config::map_tiles_y = 40;



bool Config::load_config()
{
	RaceDebug::print( "Resources: data/config.res", 7 );
	
	CL_String rpath = DATADIR;
	rpath += "data/config.scr";
	CL_ResourceManager res( rpath, false );
	
	// Theme
	Config::selected_theme = CL_Integer( "theme", &res );
	Config::random_theme = CL_Integer( "random_theme", &res );
	
	// Sound & Music
	Config::music_on = CL_Integer(  "music_on", &res );
	Config::sfx_on = CL_Integer(  "sfx_on", &res );	

	// Graphics
	Config::terrain_resolution = CL_Integer( "terrain_res", &res );
	Config::screen_resolution = CL_Integer( "terrain_res", &res );
	
	// Game
	Config::difficulty_level = CL_Integer(  "difficulty", &res )  / (float)10;
	Config::num_players = CL_Integer( "num_players", &res );
	Config::num_ai = CL_Integer( "num_ai", &res );
	
	// Keys
	Config::one_player_key_gas.id    = CL_Integer( "p1_1_g", &res );
	Config::one_player_key_brakes.id = CL_Integer( "p1_1_b", &res );
	Config::one_player_key_left.id   = CL_Integer( "p1_1_l", &res );
	Config::one_player_key_right.id  = CL_Integer( "p1_1_r", &res );

	// Misc.
	Config::save_texture = CL_Integer( "save_texture", &res );

	// Cars	
	int i=0;

	for( i=0; i < 8; i++ )
	{
		CL_String name_str = "name_";
		name_str += i;
		names.push_back(CL_String(name_str, &res));
	}
	
	for( i=0;i<8;i++ )
	{
		CL_String str = "car_";
		CL_String str_c = "car_color_"; // todo: remove or implement.
		str += i;
		str_c += i;
		
		Config::cc->car[i] = CL_Integer(str, &res );
		Config::cc->color[i] = CL_Integer(  str_c, &res );
	}
	
	return true;
}







bool Config::save_config()
{
	std::ofstream fout( "data/config.scr" );
	
	if( fout == NULL )
  		return false;
	
	int i;
	
	// Sound & Music
	fout << "music_on = "     << Config::music_on              << " (type=integer);" << std::endl;
	fout << "sfx_on = "       << Config::sfx_on                << " (type=integer);" << std::endl;

	// Game
	fout << "num_players = "  << Config::num_players           << " (type=integer);" << std::endl;
	fout << "num_ai = "       << Config::num_ai                << " (type=integer);" << std::endl;
	fout << "difficulty = "   << Config::difficulty_level * 10 << " (type=integer);" << std::endl;
	
	// Graphics
	fout << "terrain_res = " << Config::terrain_resolution << " (type=integer);" << std::endl;
	fout << "screen_res = " << Config::screen_resolution << " (type=integer);" << std::endl;

	// Theme
	fout << "random_theme = " << Config::random_theme          << " (type=integer);" << std::endl;
	fout << "theme = "        << Config::selected_theme        << " (type=integer);" << std::endl;

	// misc
	fout << "save_texture = " << Config::save_texture          << " (type=integer);" << std::endl;
	
	// Cars
	for( i=0;i<8;i++ )
	{
		CL_String str = "car_";
		str += i;
		str += " = ";
		str += Config::cc->car[i];
		str += " (type=integer);";
	  	fout << str.get_string() << std::endl;
	
		str = "car_color_";
		str += i;
		str += " = ";
		str += Config::cc->color[i];
		str += " (type=integer);";
	  	fout << str.get_string() << std::endl;
	}

	// names
	for( i=0;i<8;i++ ) 
		fout << "name_" << i << " = \"" << Config::names[i].c_str() << "\" (type=string);" << std::endl;
	
	// Keys: 
	fout << "p1_1_g = " << (int)Config::one_player_key_gas.id      << " (type=integer);" << std::endl;
	fout << "p1_1_b = " << (int)Config::one_player_key_brakes.id   << " (type=integer);" << std::endl;
	fout << "p1_1_l = " << (int)Config::one_player_key_left.id     << " (type=integer);" << std::endl;
	fout << "p1_1_r = " << (int)Config::one_player_key_right.id    << " (type=integer);" << std::endl;
	
	fout.close();
	return true;
}


