#ifndef racegl_height_map
#define racegl_height_map

class Point3D;

class HeightMap
{
 public:
	static void init();
	static void deinit();

	static void create_map();

	static bool under_water(float x, float y, float z);
	static float get_height(int x, int y);
	static float get_height_tile_coord(int x, int y);
	static CL_Surface *map_surface;
	static CL_SurfaceProvider *provider;

 private:
	static void create_terrain( const std::vector<Point3D> &points );
	static void create_road_scaled( const std::vector<Point3D> &points );
	static void create_road_repeat();
	static void scale_edges( std::vector<Point3D> &points );

	static void compile_list(char, char, const std::vector<Point3D> &points);
	static void modify_map_object_bases();

	static unsigned char *data;
	static unsigned short pitch;
	static bool get_height_inited;
};

#endif
