#include <ClanLib/core.h>
#include <ClanLib/display.h>

#include "info_gfx.h"

#include "config.h"
#include "car.h"
#include "player.h"
#include "game_data.h"
#include "debug.h"
#include "game_config.h"
#include "fonts.h"
#include "race_opengl.h"

CL_Surface *InfoGfx::speed = NULL;
CL_Surface *InfoGfx::check_flag = NULL;
CL_Surface *InfoGfx::start_lights = NULL;

int InfoGfx::flag_frame = 0;
int InfoGfx::flag_time = 0;

void InfoGfx::init()
{
	RaceDebug::print( "Resources: InfoGfx: resources/race.res", 7 );
	
	CL_String path = DATADIR;
	path +=	"resources/race.res";
	
	CL_ResourceManager resources( path, false );

	speed = CL_Surface::load("Game/sur_speed_meter", &resources);
	start_lights = CL_Surface::load("Game/sur_s_lights",   &resources);
	check_flag   = CL_Surface::load("Game/sur_small_flag", &resources);

	check_flag->put_screen(0,0); // make sure it's loaded
}



void InfoGfx::draw()
{
	Race_OpenGL::begin_2d();

	draw_lap_counter();
	draw_flag();
	draw_player_info();

	Race_OpenGL::end_2d();
}

void InfoGfx::draw_lap_counter()
{
	std::vector<Car*>::iterator it;

	for( it = GameData::cars.begin();
		 it != GameData::cars.end();
		 it++)
	{
		if( (*it)->is_player() )
		{
			CL_String lap_string("");
			if( (*it)->get_lap() <= Config::race_length )
			{
				lap_string += "Lap: ";
				lap_string += (*it)->get_lap();
				lap_string += " of ";
				lap_string += Config::race_length;
			}
			else
			  lap_string += "RACE OVER";
			
			Fonts::laps->print_right( 620, 420, lap_string.get_string());
		}
	}
}



void InfoGfx::draw_flag()
{
	if( GameData::cars_in_goal > 0  )
	{
		if( (CL_System::get_time() - flag_time) > 70 )
		{
			flag_frame++;
			if( flag_frame > 9 ) flag_frame = 0;
			flag_time = CL_System::get_time();
		}
		check_flag->put_screen( 270, 140, flag_frame );
	}
}



void InfoGfx::draw_player_info()
{
	{for(
		std::vector<Car*>::iterator it = GameData::cars.begin();
		it != GameData::cars.end();
		it++)
	{
		if( (*it)->is_player() )
		{
			(*it)->draw_speed_meter();
		}
	}}
}

