#include <ClanLib/display.h>
#include <ClanLib/gl.h>

#include "checkbox_opengl.h"
#include "stylemanager_opengl.h"

CL_CheckBox_OpenGL::CL_CheckBox_OpenGL(
	CL_CheckBox *checkbox,
	CL_StyleManager_OpenGL *style)
:
	CL_ComponentStyle(checkbox),
	checkbox(checkbox),
	style(style)
{
	resources = style->get_resources();

	font = CL_Font::load("CheckBox/font", resources);

	surface_button = new CL_Surface("CheckBox/button", resources);
	surface_checked = new CL_Surface("CheckBox/checked", resources);

	slot_paint = checkbox->sig_paint().connect_virtual(
		this, &CL_CheckBox_OpenGL::on_paint);
	slot_get_preferred_size = checkbox->sig_get_preferred_size().connect(
		this, &CL_CheckBox_OpenGL::on_get_preferred_size);
}

CL_CheckBox_OpenGL::~CL_CheckBox_OpenGL()
{
}

void CL_CheckBox_OpenGL::on_get_preferred_size(CL_Point &size)
{
	size.x = font->get_text_width(checkbox->get_text()) + 28;
	size.y = 35;
}

void CL_CheckBox_OpenGL::on_paint(CL_SlotParent_v0 &super)
{
	surface_button->put_screen(0, 0);

//	int checkbox_width = checkbox->get_width();
	int checkbox_height = checkbox->get_height();

	if(checkbox->is_down())
		surface_checked->put_screen(0, 0);

	int x_pos = 28;
	int text_height = font->get_height();
	int y_pos = (checkbox_height - text_height) / 2 - 4;

	font->print_left(x_pos, y_pos, checkbox->get_text().c_str());
}
