#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/gui.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "../menu_gfx.h"
#include "../../debug.h"
#include "../../game_config.h"
#include "../../car_loader.h"
#include "../../car_config.h"
#include "options_cars.h"


OptionsCars::OptionsCars(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(145, 150, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
		input_name( CL_Rect(460/2-10-125, 130, 460/2-10, 153), this, style ),
		lbox_cars(  CL_Rect(460/2+10, 20, 460/2+10+125, 120),  this, style ),
		lbox_names( CL_Rect(460/2-10-125, 20, 460/2-10, 120),  this, style )
{
	RaceDebug::print( "OptionsCars: constructor", 9 );
	
	slots.connect( sig_paint(), this, &OptionsCars::on_paint );
	slots.connect( lbox_cars.sig_activated(), this, &OptionsCars::on_set_car );
	slots.connect( lbox_names.sig_activated(), this, &OptionsCars::on_set_name );
	slots.connect( input_name.sig_activity(), this, &OptionsCars::on_input_name );
	
	std::vector<std::string>::iterator it;
	
	for( it = Config::names.begin(); it != Config::names.end(); it++ )
		lbox_names.insert_item((*it));
	
	CarLoader::init();	// make sure car list is loaded
	
	for( it = CarLoader::car_list.begin(); it != CarLoader::car_list.end(); it++ )
		lbox_cars.insert_item((*it));
}

void OptionsCars::on_paint()
{
	MenuGfx::submenu_frame_bg->put_screen(0,0);
}

void OptionsCars::on_set_name(int num)
{
	cout << "on set name" << endl;
	input_name.set_text(lbox_names.get_current_text());
	
	lbox_cars.clear_selection();
	lbox_cars.set_selected(Config::cc->car[num], true);
}

void OptionsCars::on_set_car(int num)
{
	int index = lbox_names.get_current_item();
	
	lbox_cars.clear_selection();
	lbox_cars.set_selected(num, true);
	
	Config::cc->car[index] = num;
	Config::cc->loaded[index] = false;
}

void OptionsCars::on_input_name()
{
	int index = lbox_names.get_current_item();
	std::string new_name = input_name.get_text();
	
	lbox_names.change_item( new_name, index );
	Config::names[index] = new_name;
}



