#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/gui.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "../menu_gfx.h"
#include "../../game_config.h"
#include "options_game.h"

OptionsGame::OptionsGame(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(145, 150, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
		scroll_num_ai(     CL_Rect( 170, 20, 280,  20+20 ), 0, 7,       true, this, style ),
		label_num_ai(      CL_Rect(  10, 20,  30,  20+20 ), "Number of AI",   this, style ),
		scroll_num_laps(   CL_Rect( 170, 60, 280,  60+20 ), 1, 10,      true, this, style ),
		label_num_laps(    CL_Rect(  10, 60,  30,  60+20 ), "Number of Laps", this, style ),
		scroll_difficulty( CL_Rect( 170, 100, 280,100+20 ), 9, 11,       true, this, style ),
		label_difficulty(  CL_Rect(  10, 100, 30, 100+20 ), "Difficulty: ",   this, style )
{
	on_num_ai(Config::num_ai);
	scroll_num_ai.set_value(Config::num_ai);
	
	on_num_laps(Config::race_length);
	scroll_num_laps.set_value(Config::race_length);
	
	on_difficulty(Config::difficulty_level*10);
	scroll_difficulty.set_value(Config::difficulty_level*10);
	
	slots.connect( sig_paint(), this, &OptionsGame::on_paint );
	slots.connect( scroll_num_ai.sig_value_changed(), this, &OptionsGame::on_num_ai );
	slots.connect( scroll_num_laps.sig_value_changed(), this, &OptionsGame::on_num_laps );
	slots.connect( scroll_difficulty.sig_value_changed(), this, &OptionsGame::on_difficulty );
}

void OptionsGame::on_paint()
{
	MenuGfx::submenu_frame_bg->put_screen(0,0);
}

void OptionsGame::on_num_ai(int num)
{
	CL_String str = "Number of AI: ";
	str += num;
	label_num_ai.set_text(str);
	
	Config::num_ai = num;
}

void OptionsGame::on_num_laps(int num)
{
	CL_String str = "Race length: ";
	str += num;
	str += " laps";
	label_num_laps.set_text(str);
	
	Config::race_length = num;
}

void OptionsGame::on_difficulty(int num)
{
	CL_String str = "Difficulty: ";
	
	if( num == 9 )
	{
		str += "really easy";
	}
	else if( num == 10 )
	{
		str += "easy";
	}
	else
	{
		str += "normal";
	}
	
	label_difficulty.set_text(str);

	Config::difficulty_level = float(num)/10.0f;
}


