#include <ClanLib/gl.h>
#include <ClanLib/display.h>
#include <ClanLib/core.h>

#include "face.h"
#include "h3d_loader.h"
#include "object_3d.h"

Object3D *Object3D::load( std::string res_name, CL_ResourceManager *res, bool set_color )
{
	CL_Resource resource = res->get_resource( res_name );
	resource.load();
	
	return new Object3D(resource.get_full_location(), set_color);
}

Object3D::Object3D( CL_String filename, bool set_color )
{
	d_list = 0;
	this->set_color = set_color;

	faces = H3DLoader::load( filename );

	// std::cout << "faces.size(): " << faces.size() << std::endl;

	max_x = max_y = max_z = min_x = min_y = min_z = 0;
	
	int i=0;
	std::vector<Face>::iterator it;
    for( it = faces.begin();
		 it != faces.end();
		 it++ )
	{
		for( i=0; i<3; i++ )
		{
			if( (*it).x[i] > max_x ) max_x = (*it).x[i];
			if( (*it).y[i] > max_y ) max_y = (*it).y[i];
			if( (*it).z[i] > max_z ) max_z = (*it).z[i];
			
			if( (*it).x[i] < min_x ) min_x = (*it).x[i];
			if( (*it).y[i] < min_y ) min_y = (*it).y[i];
			if( (*it).z[i] < min_z ) min_z = (*it).z[i];
		}
	}

	make_display_list();
}


void Object3D::make_display_list()
{
	int i = 0;
	std::vector<Face>::iterator it;


	d_list = glGenLists(1);
	
	glNewList( d_list, GL_COMPILE );
	glBegin(GL_TRIANGLES);

    for( it = faces.begin();
		 it != faces.end();
		 it++ )
	{
		for( i=0; i<3; i++ )
		{
			if( set_color )
				glColor4f( (*it).r[i], (*it).g[i], (*it).b[i], 1.0f );
			if( (*it).shade_type == 1 ) // smooth
				glNormal3f( (*it).nx[i], (*it).ny[i], (*it).nz[i] );
			if( (*it).has_tex == true ) // texture coords
				glTexCoord2f( (*it).u[i], (*it).v[i] );
			glVertex3f( (*it).x[i], (*it).y[i], (*it).z[i] );
		}
	}
	glEnd();
	glEndList();
}

void Object3D::draw()
{
	glCallList(d_list);
}
