#ifndef race_rectangle
#define race_rectangle

class RaceRect
{
 public:
	RaceRect() {};

	RaceRect(int _x1, int _y1, int _x2, int _y2 )
	{
		x1 = _x1; y1 = _y1; x2 = _x2; y2 = _y2;
	}

	bool overlapping( RaceRect &rect )
	{
		if( inside( rect.x1, rect.y1)
 		   || inside( rect.x1 + rect.get_width(), rect.y1)
 		   || inside( rect.x2, rect.y1 + rect.get_height())
		   || inside( rect.x2, rect.y2 )
		   || rect.inside( x1, y1 )
		   || rect.inside( x1 + get_width(), y1 )
		   || rect.inside( x1, y1 + get_height())
		   || rect.inside( x2, y2 ))
		{
			return true;
		}
		return false;
	}

	RaceRect clip( RaceRect rect )
	{
		RaceRect res;

		if (x1 > rect.x1) res.x1 = x1; else res.x1 = rect.x1;
		if (x2 < rect.x2) res.x2 = x2; else res.x2 = rect.x2;
		if (y1 > rect.y1) res.y1 = y1; else res.y1 = rect.y1;
		if (y2 < rect.y2) res.y2 = y2; else res.y2 = rect.y2;
	
		return res;
	}

	bool inside(int x, int y) const
	{
		return x >= x1 && y >= y1 && x < x2 && y < y2;
	}

	int get_width()
	{
		return abs( x2 - x1 );
	}

	int get_height()
	{
		return abs( y2 - y1 );
	}

	int x1, y1;
	int x2, y2;
};

#endif

