/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/gl.h>
#include <ClanLib/display.h>

#include "save_png/cl_write_png.h"
#include "graphics.h"
#include "render_track.h"
#include "tile_enums.h"
#include "track.h"
#include "map.h"
#include "track.h"
#include "blitter.h"
#include "tile_blitter.h"
#include "game_config.h"
#include "texture.h"
#include "debug.h"
#include "loading_screen.h"

void RenderTrack::render()
{
	RaceDebug::print("RenderTrack: rendering track...",2);

	// loading screen
	LoadingScreen::show(0);


	int start_time = CL_System::get_time();

	CL_Canvas *canvas = new CL_Canvas(  1024, 1024 );
	
	canvas->lock();
	
	RaceDebug::print("RenderTrack: canvas created",2);
	
/*	CL_SurfaceProvider *provider = Gfx::TrackGfx->bg->get_provider();
	if( provider->get_depth() != 32 )
		Gfx::TrackGfx->bg = Blitter::convert_to_32_bpp( Gfx::TrackGfx->bg );
	
	if( Config::mirror_fill )
	{
		Blitter::texture_fill_mirror( canvas, Gfx::TrackGfx->bg );
	}
	else
	{
		Blitter::texture_fill( canvas, Gfx::TrackGfx->bg );
	}

	RaceDebug::print("RenderTrack: Background filled",2);
*/
	RaceDebug::print("RenderTrack: Road rendering started",2);

	CL_Canvas *r_canvas = new CL_Canvas( 1024, 1024 );

	{for( int y=0; y < Config::map_tiles_y; y++ ) // blit road over terain 
	{
		for( int x=0; x < Config::map_tiles_x; x++ )
		{
			if( Track::track->get_tile_id(x,y) > 0 ) 
			{
				int scr_x = x * Config::tile_size;
				int scr_y = y * Config::tile_size;

				switch( Track::track->get_tile_id(x,y) )
				{
				 case 2:
					Blitter::put_surface_no_blending( r_canvas, Gfx::TrackGfx->r_full, scr_x, scr_y );
					break;
				 case 10:
					Blitter::put_surface_no_blending( r_canvas, Gfx::TrackGfx->r_se, scr_x, scr_y );
					break;
				 case 11:
					Blitter::put_surface_no_blending( r_canvas, Gfx::TrackGfx->r_nw, scr_x, scr_y );
					break;
				 case 12:
					Blitter::put_surface_no_blending( r_canvas, Gfx::TrackGfx->r_ne, scr_x, scr_y );
					break;
				 case 13:
					Blitter::put_surface_no_blending( r_canvas, Gfx::TrackGfx->r_sw, scr_x, scr_y );
					break;
				
				 case 18:
					Blitter::put_surface_no_blending( r_canvas, Gfx::TrackGfx->r_e, scr_x, scr_y );
					break;
				 case 19:
					Blitter::put_surface_no_blending( r_canvas, Gfx::TrackGfx->r_w, scr_x, scr_y );
					break;
				 case 20:
					Blitter::put_surface_no_blending( r_canvas, Gfx::TrackGfx->r_s, scr_x, scr_y );
					break;
				 case 21:
					Blitter::put_surface_no_blending( r_canvas, Gfx::TrackGfx->r_n, scr_x, scr_y );
					break;
				}
			}
		}
	}}
	
	RaceDebug::print("RenderTrack: road blitted.",2);
	
	RaceDebug::print("RenderTrack: road colorkey texture fill......",2);
	// Blitter::ckey_texture_fill( r_canvas, Gfx::TrackGfx->road, 1.0f, 0.0f, 1.0f );
	TileBlitter::fill_road( r_canvas, Gfx::TrackGfx->road, Track::track );
	RaceDebug::print("RenderTrack: road colorkey texture fill. - done",2);
	
	RaceDebug::print("RenderTrack: blitting road_layer on canvas......",2);
	
	CL_Surface *road_layer = CL_Surface::create( r_canvas );
	road_layer->put_screen(0,0); // make sure it is loaded
	
	TileBlitter::blit_road( canvas, road_layer, Track::track );
	
	{for( int y=0; y < Config::map_tiles_y; y++ )
	{
		for( int x=0; x < Config::map_tiles_x; x++ )
		{
			int scr_x = x * Config::tile_size;
			int scr_y = y * Config::tile_size;
			
			// finish line
			if( Track::track->get_data(x,y) == Items(FINISH) )
				Blitter::put_surface( canvas, Gfx::TrackGfx->finish, scr_x, scr_y );
		}
	}}
	RaceDebug::print("RenderTrack: bridge and start_line blitted.", 2);
	
	canvas->unlock();
	CL_Surface *sur_whole_shit = CL_Surface::create( canvas, true );
	sur_whole_shit->reload();

	if( Config::save_texture )
		WritePNG::write_png( sur_whole_shit, Track::track->get_filename() );
	
	if( Track::road_texture != NULL )
	{
		delete Track::road_texture;
		Track::road_texture = NULL;
	}
	
	Track::road_texture = new Texture( sur_whole_shit, true );
	
	RaceDebug::print("RenderTrack: sur_whole_shit created",2);
	
	delete r_canvas;
	delete road_layer;
	
	RaceDebug::print( "\nRenderTrack: time used: ",2);
	CL_String str = int((CL_System::get_time() - start_time) / 1000);
	RaceDebug::print( str.get_string(), 2);
}



