#ifndef race_theme_loader
#define race_theme_loader

class ThemeLoader
{
 public:
	static void init();
	
	static void load_random_theme();
	static void load_theme(int num);
	static void unload_theme();
	
	static std::vector<std::string> get_theme_list();
	static std::string get_theme_info(int num);
	static std::string get_theme_path(int num);

	static CL_ResourceManager *res;
	static CL_ResourceManager main_res;
	
 private:
	static void load_config();
	static void load_tiles();
	static void load_fences();
	static void load_pit();
	static void load_bridges();
	static void load_trees();
	static void load_houses();
	static void load_menu_gfx();
	static void load_dust();
	static void load_sound();
	static void load_ramps();
	static void load_water_objects();
	static void load_scroller();
	
	static bool inited;

	static std::vector<std::string> theme_list;
};

#endif
