#ifndef race_tile_enums
#define race_tile_enums

enum Items
{
	ROAD, OFF_ROAD, WATER, SLIPPERY, STICKY,

	DATA_BEGIN = 9,

	TREE_1 = 10, TREE_2, TREE_3, TREE_4, TREE_5, TREE_6, TREE_7, TREE_8, TREE_9, TREE_10,

	FENCE_H = 50, FENCE_V,

	RAMP_U = 60, RAMP_D, RAMP_L, RAMP_R,
	RAMP_U_FIX = 68, RAMP_D_FIX, RAMP_L_FIX, RAMP_R_FIX,
  
	FINISH = 80,

	/* 
	 * Bridge_Large_Horizonthal 
	 *  ---" " --- _Vertical
	 * Bridge_Small_Horizonthal
	 * Bridge_Small_Vertical
	 */

	BRIDGE_L_H = 90, BRIDGE_L_V,
	BRIDGE_S_H, BRIDGE_S_V,

	UNDER_BRIDGE = 94, OVER_BRIDGE, BRIDGE_SPEED_FIX,

  	PIT = 100, REFUEL, GET_FUEL,
	
	/*
	 * Houses:
	 *        big_h:    150x90  (5x3)
	 *        big_v:    90x150  (3x5)
	 *        big_hv:   150x150 (5x5)
	 * 
	 *        normal:   60x60   (2x2)
	 * 
	 *        small:    30x30   (1x1)
	 * 
	 * All sizes are the size of the opaque (solid) parts.
	 * The shadows/lights can be beyond that.
	 */

	HOUSE_BIG_H_1 = 200, HOUSE_BIG_H_2,HOUSE_BIG_H_3,HOUSE_BIG_H_4, HOUSE_BIG_H_5,
	HOUSE_BIG_H_6, HOUSE_BIG_H_7, HOUSE_BIG_H_8, HOUSE_BIG_H_9, HOUSE_BIG_H_10,

	HOUSE_BIG_V_1 = 210, HOUSE_BIG_V_2,HOUSE_BIG_V_3,HOUSE_BIG_V_4, HOUSE_BIG_V_5,
	HOUSE_BIG_V_6, HOUSE_BIG_V_7, HOUSE_BIG_V_8, HOUSE_BIG_V_9, HOUSE_BIG_V_10,
	
	HOUSE_BIG_HV_1 = 220, HOUSE_BIG_HV_2,HOUSE_BIG_HV_3,HOUSE_BIG_HV_4, HOUSE_BIG_HV_5,
	HOUSE_BIG_HV_6, HOUSE_BIG_HV_7, HOUSE_BIG_HV_8, HOUSE_BIG_HV_9, HOUSE_BIG_HV_10,
	
	// TODO: fix enum values...
	HOUSE_1 = 30, HOUSE_2, HOUSE_3, HOUSE_4, HOUSE_5, HOUSE_6, HOUSE_7, HOUSE_8, HOUSE_9, HOUSE_10,

	HOUSE_SMALL_1 = 230, HOUSE_SMALL_2,HOUSE_SMALL_3,HOUSE_SMALL_4, HOUSE_SMALL_5,
	HOUSE_SMALL_6, HOUSE_SMALL_7, HOUSE_SMALL_8, HOUSE_SMALL_9, HOUSE_SMALL_10,

	 // misc animations. (on land)
	 
	ANIMATION_1 = 300, ANIMATION_2, ANIMATION_3, ANIMATION_4, ANIMATION_5,
	ANIMATION_6, ANIMATION_7, ANIMATION_8, ANIMATION_9, ANIMATION_10,

	/* Objects in water. everything that is placed in liquid should go
	 * here.
	 */

	WATER_OBJECT_1 = 400, WATER_OBJECT_2, WATER_OBJECT_3, WATER_OBJECT_4, WATER_OBJECT_5,
	WATER_OBJECT_6, WATER_OBJECT_7, WATER_OBJECT_8, WATER_OBJECT_9, WATER_OBJECT_10,

	/* Scrollers scroll the surface continioulsy using clip rects either
	 * horiz or vertically.
	 */

	SCROLLER_X_1 = 500, SCROLLER_X_2, SCROLLER_X_3, SCROLLER_X_4, SCROLLER_X_5,
	SCROLLER_X_6, SCROLLER_X_7, SCROLLER_X_8, SCROLLER_X_9, SCROLLER_X_10,

	SCROLLER_Y_1 = 510, SCROLLER_Y_2, SCROLLER_Y_3, SCROLLER_Y_4, SCROLLER_Y_5,
	SCROLLER_Y_6, SCROLLER_Y_7, SCROLLER_Y_8, SCROLLER_Y_9, SCROLLER_Y_10,

	DATA_END = 600,

	NO_ITEM = 999,
  
  	/* used by the editor... This doesn't belong here but putting it here
	 saved me some trouble :) */
  
	NEW = 2000, LOAD, SAVE, SAVE_AS, EXIT,

	ATTR = 2100, ATTR_OK_AREA, START_POSITION
};


#endif
