#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>

#include "texture.h"
#include "track_gfx.h"
#include "debug.h"
#include "config.h"
#include "object_3d.h"
#include "map_objects/all.h"

track_gfx::track_gfx()
{
	// track = NULL;

	r_full = NULL;
	r_n = NULL;
	r_e = NULL;
	r_w = NULL;
	r_s = NULL;
	r_nw = NULL;
	r_ne = NULL;
	r_sw = NULL;
	r_se = NULL;

	bg = NULL;
	water = NULL;
	road = NULL;

	dust = NULL;

	dust_road_texture = NULL;
	dust_water_texture = NULL;

	finish = NULL;
}

void track_gfx::init()
{
	RaceDebug::print( "Resources: TrackGfx: resources/race.res", 7 );

	CL_String path = DATADIR;
	path += "resources/race.res";
	CL_ResourceManager resources( path, false );
	
	finish = CL_Surface::load( "Default/start", &resources );
	
	dust = Object3D::load( "Game/dust", &resources, false );
}

