/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999-2002,  Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/gl.h>

void Water::draw()
{
	int begin, end, elapsed;
	GLfloat matrix[16];

	if (set_timeout)
	{
		begin = glutGet(GLUT_ELAPSED_TIME);
	}
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glPushMatrix();

	glScalef(size, size, size);

	glMatrixMode(GL_TEXTURE);
	makeSift(matrix, 0.02 * cos(tick1 / 40.0), 0.02 * sin(tick1 / 15.0));
	glLoadMatrixf(matrix);
	glMatrixMode(GL_MODELVIEW);

	glCallList(1);

	glPopMatrix();
	glutSwapBuffers();

	if (set_timeout)
	{
		set_timeout = 0;
		end = glutGet(GLUT_ELAPSED_TIME);
		elapsed = end - begin;

		if (elapsed > interval)
		{
			glutTimerFunc(0, animate, 1);
		}
		else
		{
			glutTimerFunc(interval - elapsed, animate, 1);
		}
	}	
}

void Water::animate(int value)
{
	if (value)
	{
		if (sifting)
		{
			tick1 += 4 * (interval / 100.0);
			angle = ((int) tick1) % 360;
		}
	}
	set_timeout = 1;
}

void Water::makeSift( GLfloat m[16], float xsift, float ysift )
{
	m[0 + 4 * 0] = 1;
	m[0 + 4 * 1] = 0;
	m[0 + 4 * 2] = xsift;
	m[0 + 4 * 3] = 0;

	m[1 + 4 * 0] = 0;
	m[1 + 4 * 1] = 1;
	m[1 + 4 * 2] = ysift;
	m[1 + 4 * 3] = 0;

	m[2 + 4 * 0] = 0;
	m[2 + 4 * 1] = 0;
	m[2 + 4 * 2] = 1;
	m[2 + 4 * 3] = 0;

	m[3 + 4 * 0] = 0;
	m[3 + 4 * 1] = 0;
	m[3 + 4 * 2] = 0;
	m[3 + 4 * 3] = 1;
}

