#lang racket/base

(provide (all-defined-out))

(define currency-code->sign
  #hash((ALL . "Lek")
        (AFN . "\u60b")
        (ARS . "$")
        (AWG . "\u192")
        (AUD . "$")
        (AZN . "\u43c\u430\u43d")
        (BSD . "$")
        (BBD . "$")
        (BYR . "p.")
        (BZD . "BZ$")
        (BMD . "$")
        (BOB . "$b")
        (BAM . "KM")
        (BWP . "P")
        (BGN . "\u43b\u432")
        (BRL . "R$")
        (BND . "$")
        (KHR . "\u17db")
        (CAD . "$")
        (KYD . "$")
        (CLP . "$")
        (CNY . "\ua5")
        (COP . "$")
        (CRC . "\u20a1")
        (HRK . "kn")
        (CUP . "\u20b1")
        (CZK . "\u4b\u10d")
        (DKK . "kr")
        (DOP . "RD$")
        (XCD . "$")
        (EGP . "\ua3")
        (SVC . "$")
        (EEK . "kr")
        (EUR . "\u20ac")
        (FKP . "\ua3")
        (FJD . "$")
        (GHC . "\ua2")
        (GIP . "\ua3")
        (GTQ . "Q")
        (GGP . "\ua3")
        (GYD . "$")
        (HNL . "L")
        (HKD . "$")
        (HUF . "Ft")
        (ISK . "kr")
        (INR . "\u20B9")
        (IDR . "Rp")
        (IRR . "\ufdfc")
        (IMP . "\ua3")
        (ILS . "\u20aa")
        (JMD . "J$")
        (JPY . "\ua5")
        (JEP . "\ua3")
        (KZT . "\u43b\u432")
        (KPW . "\u20a9")
        (KRW . "\u20a9")
        (KGS . "\u43b\u432")
        (LAK . "\u20ad")
        (LVL . "Ls")
        (LBP . "\ua3")
        (LRD . "$")
        (LTL . "Lt")
        (MKD . "\u434\u435\u43d")
        (MYR . "RM")
        (MUR . "\u20a8")
        (MXN . "$")
        (MNT . "\u20ae")
        (MZN . "MT")
        (NAD . "$")
        (NPR . "\u20a8")
        (ANG . "\u192")
        (NZD . "$")
        (NIO . "C$")
        (NGN . "\u20a6")
        (KPW . "\u20a9")
        (NOK . "kr")
        (OMR . "\ufdfc")
        (PKR . "\u20a8")
        (PAB . "B/.")
        (PYG . "Gs")
        (PEN . "S/.")
        (PHP . "\u20b1")
        (PLN . "z\u142")
        (QAR . "\ufdfc")
        (RON . "lei")
        (RUB . "\u440\u443\u431")
        (SHP . "\ua3")
        (SAR . "\ufdfc")
        (RSD . "\u414\u438\u43d.")
        (SCR . "\u20a8")
        (SGD . "$")
        (SBD . "$")
        (SOS . "S")
        (ZAR . "R")
        (KRW . "\u20a9")
        (LKR . "\u20a8")
        (SEK . "kr")
        (CHF . "CHF")
        (SRD . "$")
        (SYP . "\ua3")
        (TWD . "NT$")
        (THB . "\ue3f")
        (TTD . "TT$")
        (TRY . "TL")
        (TRL . "\u20a4")
        (TVD . "$")
        (UAH . "\u20b4")
        (GBP . "\ua3")
        (USD . "$")
        (UYU . "$U")
        (UZS . "\u43b\u432")
        (VEF . "Bs")
        (VND . "\u20ab")
        (YER . "\ufdfc")
        (ZWD . "Z$")))

(define known-currency-codes (sort (hash-keys currency-code->sign) string<=? #:key symbol->string))
