#!/bin/csh -f
#
# Get pcomb arguments for the given sky
#
set TREGDATF=tregsamp.dat
set TREGSRC=tregsrc.cal
if ($#argv < 4) then
	echo "Usage: $0 base gensky_args"
	exit 1
endif
set base=$1
gensky $argv[2-] >/tmp/sky$$.rad
cat >/tmp/sun$$.fmt << '_EOF_'
void light $(smat)
0
0
3 ${sbr} ${sbg} ${sbb}

$(smat) source $(snam)
0
0
4 ${sdx} ${sdy} ${sdz} 0.5
'_EOF_'
set sun=`rcalc -i /tmp/sun$$.fmt -e '$1=sdx;$2=sdy;$3=sdz;$4=sbg' /tmp/sky$$.rad`
if ($#sun == 4) then
	set bestsun=`cnt 145 | rcalc -f $TREGSRC -e 'Tbin=recno' \
		-o '${'Dx\*$sun[1]+Dy\*$sun[2]+Dz\*$sun[3]'} ${Tbin} ${Tomega}' | sort -nr | head -4`
        set scale=`echo $bestsun | rcalc -e 'wt(c):1/(1.00001-c*c)' \
                -e 'wt1=wt($1);wt2=wt($4);wt3=wt($7);wt4=wt($10)' \
                -e "norm=$sun[4]/(wt1+wt2+wt3+wt4)" -e 'SOM:6e-5' \
		-e 'om1=SOM/$3;om2=SOM/$6;om3=SOM/$9;om4=SOM/$12' \
                -e '$1=wt1*om1*norm;$2=wt2*om2*norm' \
		-e '$3=wt3*om3*norm;$4=wt4*om4*norm'`
	echo -s $scale[1] $base$bestsun[2].hdr
	echo -s $scale[2] $base$bestsun[5].hdr
	echo -s $scale[3] $base$bestsun[8].hdr
	echo -s $scale[4] $base$bestsun[11].hdr
endif
echo "skyfunc glow skyglow 0 0 4 1 1 1 0 skyglow source sky 0 0 4 0 0 1 360" \
	| oconv /tmp/sky$$.rad - > /tmp/sky$$.oct
rtrace -h -w- -dv- /tmp/sky$$.oct < $TREGDATF \
	| total -64 -m \
	| rcalc -s base=$base -e 'cond=$2-1e-20' \
		-o '-s ${$2} $(base)${recno-1}.hdr'
rm /tmp/sky$$.rad /tmp/sun$$.fmt /tmp/sky$$.oct
