#!/usr/bin/python
#
#  Copyright (c) 1998-2001 Sean Reifschneider, tummy.com, ltd.  
#	All Rights Reserved.
#
#  Module which generates RAW text-format reports, suitable for import to a
#  spread-sheet.  Is called by the generator.py module *ONLY*.  Requires
#  only being imported by the "stdreport" program, it automatically
#  registers with the generator to generate reports.
#
#  http://www.tummy.com/radiusContext/
#  ftp://ftp.tummy.com/pub/tummy/radiusContext/

import time
import generator
from radiussupp import *
import os

headLine = "Login Date              Time This    Total      BW In/Out" +  \
		"        Reason\n"
seppLine = "=============================================" + \
		"===============================\n"

class genraw:
	genname = "raw"

	def __init__(self):
		self.out = None
		self.outIndex = None
		self.reportDirName = "."
		self.reportIndexName = "index"
		self.reportSuffix = ".raw"
		self.splitNum = None

	def setSplit(self, split = None):
		self.splitNum = split

	def reportDir(self, name):
		self.reportDirName = name

	def reportIndex(self, name):
		self.reportIndexName = name

	def Start(self, sesData):
		dir = self.reportDirName + '/'
		if self.splitNum > 0:
			dir = '%s%s/' % ( dir, sesData['userName'][:self.splitNum] )

		try: os.mkdir(dir)
		except os.error: pass
		self.out = open(dir + sesData["userName"] + self.reportSuffix, "w")
		self.out.write("Session report for: %s\n" % ( sesData["userName"] ))
		self.out.write(headLine)
		self.out.write(seppLine)

	def Stop(self, sesData):
		if self.out != None:
			self.out.write(seppLine)
			self.out.write("Total Online Time: %s   Days on: %s\n"
					% ( longToStr(sesData["timeOn"]),
					longToStr(sesData["numDays"]) ))
			self.out.write("Average Online Times:  %s per day,  %s per session\n"
					% ( longToStr(sesData["timeOn"] / sesData["numDays"]),
					longToStr(sesData["timeOn"] / sesData["sessionCount"]) ))

			self.out.write(
					"Total Data Transferred In/Out:  %s/%s  Rate In/Out: %s/%s\n"
					% ( longToStr(sesData["bytesIn"]),
					longToStr(sesData["bytesOut"]),
					sesData["bwIn"], sesData["bwOut"] ))
			self.out.write("\nGenerated by radiusContext "+
					"(http://www.tummy.com/radiusContext/)\n")
			self.out.close()
			self.out = None

	def Item(self, userData, sesData):
		termReason = sesData.get("Acct-Terminate-Cause", "")
		if termReason == "User-Request":
			termReason = ""
		if not termReason:
			termReason = sesData.get("Ascend-Disconnect-Cause", "")

		self.out.write("%-23s  %8s %8s  %9s/%-9s  %s\n" %
				( sesData["Session-Start-Date"],
				longToStr(sesData["currentTime"]),
				longToStr(userData["timeOn"]),
				sesData["currentIn"],
				sesData["currentOut"],
				termReason ))

	def IndexStart(self):
		self.outIndex = open(self.reportDirName + "/" + self.reportIndexName
				+ self.reportSuffix, "w")
		self.outIndex.write("Overall Dial-In Report generated %s\n\n" %
				( time.strftime("%A, %B %d, %Y", time.localtime(time.time())) ))
		self.outIndex.write("                        " + 
				"       Times Online in Sec\n")
		self.outIndex.write(
			"User Name            SesNum   Total  Per Day  Per Ses        " +
			"BW In/Out\n")
		self.outIndex.write(seppLine)

	def IndexStop(self, indexData):
		if self.outIndex != None:
			self.outIndex.write(seppLine)

			self.outIndex.write(
					"Average Online Time: %s per user, %s per session\n" %
					( longToStr(indexData["timePerUser"]),
					longToStr(indexData["timePerSes"]) ))
			self.outIndex.write("Average Sessions: %s per user\n" % (
					longToStr(indexData["sesPerUser"]) ))
			self.outIndex.write(
					"Data In/Out: %s/%s total, %s/%s per user, %s/%s per session\n" %
					( longToStr(indexData["bytesIn"]),
					longToStr(indexData["bytesOut"]),
					longToStr(indexData["dataInPerUser"]),
					longToStr(indexData["dataOutPerUser"]),
					longToStr(indexData["dataInPerSes"]),
					longToStr(indexData["dataOutPerSes"]) ))

			self.outIndex.write(
					"Throughput In/Out: %s/%s total, %s/%s per user\n" %
					( longToStr(indexData["bytesIn"]),
					longToStr(indexData["bytesOut"]),
					longToStr(tryDivide(indexData["bytesIn"],
					indexData["timePerUser"])),
					longToStr(tryDivide(indexData["bytesOut"],
					indexData["timePerUser"])) ))
			self.outIndex.write("\nGenerated by radiusContext "+
					"(http://www.tummy.com/radiusContext/)\n")
			self.outIndex.close()
			self.outIndex = None

	def IndexItem(self, indexData, userData):
		self.outIndex.write("%-20s  %4s  %7s  %7s  %7s  %11s/%-11s\n" %
				( userData["userName"], longToStr(userData["sessionCount"]),
				longToStr(userData["timeOn"]),
				longToStr(userData["timeOn"] / userData["numDays"]),
				longToStr(userData["timeOn"] / userData["sessionCount"]),
				longToStr(userData["bytesIn"]),
				longToStr(userData["bytesOut"]) ))
		self.outIndex.flush()

generator.append(genraw())
