#!/usr/bin/python
#
#  Copyright (c) 1998, Sean Reifschneider, tummy.com, ltd.  All Rights Reserved.
#
#  Support routines for radiusContext.
#
#  http://www.tummy.com/radiusContext/
#  ftp://ftp.tummy.com/pub/tummy/radiusContext/


secsTable = [
	( 604800, "w", "week" ),
	( 86400, "d", "day" ),
	( 3600, "h", "hour" ),
	( 60, "m", "minute" ),
	( 1, "s", "second" )
	]


#########################
def limitSecsToStr(secs):
	'''Remove conversion settings that are greater than "secs" long.
	Can only be called once per program run.'''
	while secsTable[0][0] > secs:
		del(secsTable[0])


###############################
def secsToStr(secs, max = 100):
	str = ""

	format = "%d%s"
	for ( secsPer, shortDesc, longDesc ) in secsTable:
		if secs >= secsPer:
			str = str + format % ( secs / secsPer, shortDesc )
			secs = secs % secsPer
			max = max - 1
			format = "%02d%s"
		if max < 1:
			break
	return(str)


######################
def bytesToStr(bytes):
	try:
		if (bytes > 1024000000):
			return("%.1fG" % ( bytes / 1024000000.0 ));
		if (bytes > 1024000):
			return("%.1fM" % ( bytes / 1024000.0 ));
		if (bytes > 1024):
			return("%.1fK" % ( bytes / 1024.0 ));
		return("%dB" % ( bytes ));
	except OverflowError:
		return('[Invalid: "%s"]' % str(bytes))

def tryDivide(a, b):
	try:
		return(a / b)
	except:
		return(0)

def longToStr(val):
	s = str(val)
	if s[-1] == "L":
		s = s[:-1]
	return(s)
