#include "defs.h"
#include "explode.h"
#include "explode_animate.h"
#include "allegro.h"
#include "rafkill.h"

ExplosionAnimate::ExplosionAnimate( int cx, int cy, double dx, double dy, int _first_pic, int _last_pic ):
ExplosionClass( cx, cy, dx, dy, 99 ) {
	first_pic = _first_pic;
	radius = first_pic;
	last_pic = _last_pic;
}


bool ExplosionAnimate::update() {
	vx += wx;
	vy += wy;
	x = (int)vx;
	y = (int)vy;

	if ( ++radius > last_pic ) return true;
	return false;
}


void ExplosionAnimate::Draw( BITMAP * who, int offset ) {
	int mx = ((BITMAP *)global_data[ radius ].dat)->w/2;
	int my = ((BITMAP *)global_data[ radius ].dat)->h/2;
	draw_sprite( who, (BITMAP *)global_data[ radius ].dat, x-mx, y-my+offset );
}
