#include "playerobj.h"
#include "shipobj.h"
#include "spaceobj.h"
#include "booster.h"
#include "gunobj.h"
#include "hull.h"
#include "hull_player.h"

PlayerObject::PlayerObject(int qx, int qy, int _difficulty, HullObject * hnew):
ShipObject(qx,qy,0,hnew,NULL,NULL,TEAM_PLAYER),
difficulty( _difficulty ),
change_frame( 0 ),
holding_accessory( true ) {
	engine = new Booster();
	score = 10000;
}


PlayerObject::~PlayerObject() {
	delete engine;
}


bool PlayerObject::acceptSpecial() {
	return true;
}


void PlayerObject::Radar( BITMAP * rad ) {

	circlefill( rad, (int)( (float)actualx / ( (float)screen_x / (float)rad->w  ) ), (int)( (float)actualy / ( (float)screen_y / (float)rad->h  ) ), 1, makecol(100,200,50) );

}


void PlayerObject::Draw(BITMAP * less, ExplosionClass ** _explr, int MAX_EXPLR, int g, int offset ) {

	if ( g != hull->drawLevel ) return;

	WeaponObject ** myGun = hull->Guns();
	for ( int q = 0; q < hull->maxGuns(); q++ )
		if ( myGun[q] != NULL )
			myGun[q]->Draw( less, actualx, actualy+offset );

	PlayerHull * ph = (PlayerHull *)hull;
	if ( ph->life < 30 ) {

		for ( int q = 0; q < 3; q++ ) {
			#define garb 35
			if ( rnd( (int)ph->life ) == rnd( (int)ph->life ) ) {
				if ( _explr != NULL )
					addExplode( _explr, MAX_EXPLR, new ExplosionClass(actualx+rnd(garb)-garb/2,
						actualy+rnd(garb)-garb/2,
						0,4.8,
						rnd( 3 ) + 5 ) );
			}
			#undef garb
		}

	}

	engine->Draw( less, offset );
	ph->Draw( less, actualx, actualy+offset );

	/*
	char * numnum = int2normal(score);
	char * final = append("Score ",numnum);
	raptor_font->rtext(less,11,GRAPHICS_Y-raptor_font->height()+offset,makecol(255,128,0),final);
	free( numnum );
	free( final );
	ph->Draw( less, dat, actualx, actualy+offset );
	ph->showAttribute( less, ph->life, ph->max(0), screen_x-10, offset );
	ph->showAttribute( less, ph->shield, ph->max(1), 1, offset );
	*/
}


bool PlayerObject::powerUp() {
	return false;
}


void PlayerObject::MoveD( double & d, double f_max ) {

	#define move_change 3.9

	if ( f_max > 0 ) {
		d += move_change;
		if ( d > f_max ) d = f_max;
	}
	else {
		d -= move_change;
		if ( d < f_max ) d = f_max;
	}

}


bool PlayerObject::MoveMe( vector< SpaceObject * > * Ammo, vector< SpaceObject * > * fight, Section * onscreen,DATAFILE * snd ) {

	#define move_quick 11.23
	//int last_dir = 0;
	//bool moved_x = false;
	//bool moved_y = false;

	accel_x = 0;
	accel_y = 0;
	if ( key[KEY_UP] || key[KEY_W] || key[KEY_8_PAD] ) {
		//MoveXY( 0, -move_quick );
		//MoveD( dy, -move_quick );
		accel_y = -move_quick;
		if ( change_frame % 2 == 0 ) {
			engine->add( actualx-7, actualy );
			engine->add( actualx+7, actualy );
		}
		//moved_y = true;
	}
	if ( key[KEY_DOWN] || key[KEY_X] || key[KEY_S] || key[KEY_2_PAD] ) {
		//MoveXY( 0, move_quick );
		//MoveD( dy, move_quick );
		accel_y = move_quick;
		//moved_y = true;
	}

	if ( ++change_frame >= 10 ) change_frame = 0;

	if ( key[KEY_RIGHT] || key[KEY_D] || key[KEY_6_PAD] ) {
		//MoveD( dx, move_quick );
		accel_x = move_quick;
		//last_dir = 1;
		//moved_x = true;
	}
	if ( key[KEY_LEFT] || key[KEY_A] || key[KEY_4_PAD] ) {
		//MoveD( dx, -move_quick );
		accel_x = -move_quick;
		//last_dir = -1;
		//moved_x = true;
	}

	if ( !holding_accessory )
	if ( key[KEY_ALT] || key[KEY_ALTGR] ) {
		((PlayerHull *)hull)->NextAccessory();
		holding_accessory = true;
	}

	if ( !key[KEY_ALT] && !key[KEY_ALTGR] ) holding_accessory = false;

	/*
	if ( change_frame % 2 == 0 ) {
		PlayerHull * ph = (PlayerHull *)hull;
		ph->frameStable();
		if ( last_dir == 1 )
			for ( int q = 0; q < 2; q++ )
				ph->frameRight();
		if ( last_dir == -1 )
			for ( int q = 0; q < 2; q++ )
				ph->frameLeft();
	}
	*/

	MoveD( dx, accel_x );
	MoveD( dy, accel_y );

	//if ( !moved_x )
	//	Inertia( dx );
	//if ( !moved_y )
	//	Inertia( dy );
	if ( accel_x != 0 )
		Inertia( dx );
	if ( accel_y != 0 )
		Inertia( dy );
	MoveReal();
	CheckXY();

	if ( hull ) hull->Moved( this->DX(), this->DY(), this->AccelX(), this->AccelY() );
	if ( hull ) hull->addSection( this, onscreen, actualx, actualy );

	WeaponObject ** myGun = hull->Guns();
	for ( int q = 0; q < hull->maxGuns(); q++ )
	if ( myGun[q] != NULL ) {
		if ( myGun[q]->shot_counter > 0 )
			myGun[q]->shot_counter--;
		else {
			if ( key[KEY_SPACE]||key[KEY_ENTER]||key[KEY_ENTER_PAD] )
				myGun[q]->MakeShot( actualx, actualy-10, Ammo, fight );
			else myGun[q]->Idle(actualx,actualy-10,Ammo,fight);
		}
	}

	return false;

}


void PlayerObject::CheckXY() {
	if ( actualx > screen_x ) {
		actualx = screen_x;
		virtualx = actualx;
	}
	if ( actualx < 0 ) {
		actualx = 0;
		virtualx = actualx;
	}
	if ( actualy < 0 ) {
		actualy = 0;
		virtualy = actualy;
	}
	if ( actualy >= screen_y-30 ) {
		actualy = screen_y-30;
		virtualy = actualy;
	}
}


void PlayerObject::Inertia( double & d ) {
	#define slowdown 1.69
	if ( d > slowdown ) d -= slowdown;
	else if ( d < -slowdown ) d += slowdown;
	else d = 0;
}
