#include "weaponobj.h"
#include "spaceobj.h"
#include "hull.h"
#include "trigtable.h"
#include "sound.h"
#include "defs.h"
#include "rafkill.h"
#include "explode.h"

WeaponNode::WeaponNode(int qx, int qy, double kx, double ky, HullObject * hnew, int alignment):
SpaceObject(qx,qy,kx,ky, hnew, NULL, PLANE_AIR | PLANE_GROUND, alignment ){}

bool WeaponNode::Damage( double much ) {
	hull->takeDamage( getLife() );
	hull->takeDamage( NO_EXPLODE );
	return true;
}


void WeaponNode::Died( SpaceObject * check, ExplosionClass ** explr, int ME, DATAFILE * sd ) {
	play_sound( sd, sustain, 50 );
	Explode( explr, ME );
}


void WeaponNode::Explode( ExplosionClass ** explr, int ME ) {
	//double a = (double)( rnd( 45 ) + 15 ) / -10.0;
	//addExplode( explr, ME, new ExplosionClass(actualx,actualy,0,a,rnd(6) + 3 ) );
	addExplode( explr, ME, new ExplosionClass(actualx,actualy,this->DX()/2,this->DY()/2,rnd(6) + 3 ) );

}


WeaponNode::~WeaponNode() {
}
