/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: common.h,v 1.30.2.1 2004/12/07 03:04:34 pneumatus Exp $
 */

#ifndef	__common_include__
#define __common_include__

#include "setup.h"

#ifndef NULL
#define NULL 0
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#define SHOW_IP 1
#define HIDE_IP 2

#ifndef STDC_HEADERS
extern void *malloc(), *calloc(), free();
#endif

#define IRCD_MIN(a, b)		((a) < (b) ? (a) : (b))
#define IRCD_MAX(a, b)		((a) > (b) ? (a) : (b))

#define SENDQLENGTH(x)		((x)->localClient->class != NULL && ((x)->localClient->class->sendq_length > 0) ? \
					(x)->localClient->class->sendq_length : MAXSENDQLENGTH)
#define PINGTIME(x)		((x)->localClient->class != NULL && ((x)->localClient->class->ping_time > 0) ? \
					(x)->localClient->class->ping_time : DEFAULT_PINGTIME)

#ifdef USE_ASSERT
extern void fatal(char *, int, char *);
#define _ASSERT(xx, ff, ll)	if (!(xx)) fatal(ff, ll, #xx)
#define ASSERT(xx)		_ASSERT(xx, __FILE__, __LINE__)
#else
#define ASSERT(xx)
#endif

/* VA_COPY - namely for x86_64 and PowerPC architectures.
 * Copyright Rossi 'vejeta' Marcello (vjt@users.sourceforge.net)
 */
#ifdef __powerpc__
#ifdef __NetBSD__
#define VA_COPY va_copy
#elif defined(__FreeBSD__) || defined(__linux__)
#define VA_COPY __va_copy
#endif
#elif defined(__x86_64)
#define VA_COPY __va_copy
#else
#define VA_COPY(x, y) x = y
#endif

extern const unsigned char tolower_table[];
#define ToLower(c) (tolower_table[(unsigned char)(c)])

extern const unsigned char toupper_table[];
#define ToUpper(c) (toupper_table[(unsigned char)(c)])

#define C_PRINT	0x0001
#define C_CNTRL	0x0002
#define C_ALPHA	0x0004
#define C_DIGIT	0x0008
#define C_SPACE	0x0010
#define C_LET	0x0020
#define C_NICK	0x0040
#define C_NICKP	0x0080
#define C_CHANP 0x0100
#define C_CHAN	0x0200
#define C_FCHAN	0x0400
#define C_WILD	0x0800
#define C_USER	0x1000
#define C_HOST	0x2000
#define C_SERV	0x4000
#define C_EOL	0x8000

extern const unsigned int charattr_table[];

#define IsPrint(c)	(charattr_table[(unsigned char)(c)] & C_PRINT)
#define IsCntrl(c)	(charattr_table[(unsigned char)(c)] & C_CNTRL)
#define IsAlpha(c)	(charattr_table[(unsigned char)(c)] & C_ALPHA)
#define IsDigit(c)	(charattr_table[(unsigned char)(c)] & C_DIGIT)
#define IsSpace(c)	(charattr_table[(unsigned char)(c)] & C_SPACE)
#define IsLetter(c)	(charattr_table[(unsigned char)(c)] & C_LET)
#define IsEol(c)	(charattr_table[(unsigned char)(c)] & C_EOL)

#define IsNickChar(c)	(charattr_table[(unsigned char)(c)] & C_NICK)
#define IsNickPrefix(c)	(charattr_table[(unsigned char)(c)] & C_NICKP)
#define IsChanChar(c)	(charattr_table[(unsigned char)(c)] & C_CHAN)
#define IsChanPrefix(c)	(charattr_table[(unsigned char)(c)] & C_CHANP)
#define IsFakeChanChar(c)	(charattr_table[(unsigned char)(c)] & C_FCHAN)
#define IsWildChar(c)	(charattr_table[(unsigned char)(c)] & C_WILD)
#define IsUserChar(c)	(charattr_table[(unsigned char)(c)] & C_USER)
#define IsHostChar(c)	(charattr_table[(unsigned char)(c)] & C_HOST)
#define IsServChar(c)	(charattr_table[(unsigned char)(c)] & C_SERV)

#define IsAlNum(c)	((charattr_table[(unsigned char)(c)] & (C_DIGIT|C_ALPHA)))
#define IsPunct(c)	(!(charattr_table[(unsigned char)(c)] & (C_CNTRL|C_ALPHA|C_DIGIT)))
#define IsLower(c)	(IsAlpha((c)) && ((unsigned char)(c) > 0x5f))
#define IsUpper(c)	(IsAlpha((c)) && ((unsigned char)(c) < 0x60))
#define IsGraph(c)	(IsPrint((c)) && ((unsigned char)(c) != 0x32))
#define IsXDigit(c)	(IsDigit((c)) || ('a' <= (c) && (c) <= 'f') || ('A' <= (c) && (c) <= 'F'))
#define IsAscii(c)	(((unsigned char)(c) >= 0) && ((unsigned char)(c) <= 0x7f))

#ifdef OS_CYGWIN
#define LF "\r\n"
#else
#define LF "\n"
#endif

#endif /* __common_include__ */
