/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: msg.h,v 1.92.2.1 2004/12/07 03:04:37 pneumatus Exp $
 */

#ifndef	__msg_include__
#define __msg_include__

#define MAXPARA 17

typedef struct _msg_ptr msg_ptr;
typedef struct _command Command;

struct _msg_ptr {
	char *msg_str;
	char *tok_str;
	unsigned short flags;
};

struct _command {
	Command *next, *prev;
	msg_ptr *msg;
	int (*func)();
	unsigned int count;
	unsigned long bytes;
	Module *owner;
};

#define CMDFLAG_NONE		0x00	/* No flags */
#define CMDFLAG_UNREGUSE	0x01	/* Allow unregistered usage */
#define CMDFLAG_RESETIDLE	0x02	/* Function resets idle time */
#define CMDFLAG_SINGLEPARA	0x04	/* Takes single parameter only */
#define CMDFLAG_TOK1ONLY	0x08	/* TOK1 only (uberkludge) */

#define MSG_CHANSERV	"CHANSERV"
#define MSG_CS		"CS"
#define MSG_NICKSERV	"NICKSERV"
#define MSG_NS		"NS"
#define MSG_MEMOSERV	"MEMOSERV"
#define MSG_MS		"MS"
#define MSG_OPERSERV	"OPERSERV"
#define MSG_OS		"OS"
#define MSG_STATSERV	"STATSERV"
#define MSG_SS		"SS"
#define MSG_HOSTSERV	"HOSTSERV"
#define MSG_HS		"HS"
#define MSG_BOTSERV	"BOTSERV"
#define MSG_BS		"BS"
#define MSG_SERVICES	"SERVICES"
#define MSG_IDENTIFY	"IDENTIFY"
#define MSG_ACCEPT	"ACCEPT"
#define MSG_ADMIN	"ADMIN"
#define MSG_AKILL	"AKILL"
#define MSG_AWAY	"AWAY"
#define MSG_BURST	"BURST"
#define MSG_CAPAB	"CAPAB"
#define MSG_CHATOPS	"CHATOPS"
#define MSG_CLOSE	"CLOSE"
#define MSG_CONNECT	"CONNECT"
#define MSG_DALINFO	"DALINFO"
#define MSG_DCCALLOW	"DCCALLOW"
#define MSG_DIE		"DIE"
#define MSG_DKEY	"DKEY"
#define MSG_ERROR	"ERROR"
#define MSG_GLOBOPS	"GLOBOPS"
#define MSG_GNOTICE	"GNOTICE"
#define MSG_INFO	"INFO"
#define MSG_INVITE	"INVITE"
#define MSG_ISON	"ISON"
#define MSG_JOIN	"JOIN"
#define MSG_KICK	"KICK"
#define MSG_KILL	"KILL"
#define MSG_KLINE	"KLINE"
#define MSG_KNOCK	"KNOCK"
#define MSG_LINKS	"LINKS"
#define MSG_LIST	"LIST"
#define MSG_LOCOPS	"LOCOPS"
#define MSG_LUSERS	"LUSERS"
#define MSG_MAP		"MAP"
#ifndef STATIC_MODULES
#define MSG_MODULE	"MODULE"
#endif
#define MSG_PRIVMSG	"PRIVMSG"
#define MSG_PRIVMSG_D	"PRIVMSG"
#define MSG_NOTICE	"NOTICE"
#define MSG_NOTICE_D	"NOTICE"
#define MSG_MKPASSWD	"MKPASSWD"
#define MSG_MODE	"MODE"
#define MSG_MOTD	"MOTD"
#define MSG_MYID	"MYID"
#define MSG_NAMES	"NAMES"
#define MSG_NICK	"NICK"
#define MSG_OPER	"OPER"
#define MSG_OPERMOTD	"OPERMOTD"
#define MSG_PART	"PART"
#define MSG_PASS	"PASS"
#define MSG_PING	"PING"
#define MSG_PONG	"PONG"
#define MSG_QUIT	"QUIT"
#define MSG_RAKILL	"RAKILL"
#define MSG_REHASH	"REHASH"
#define MSG_RESTART	"RESTART"
#define MSG_RESYNCH	"RESYNCH"
#define MSG_RULES	"RULES"
#define MSG_SAJOIN	"SAJOIN"
#define MSG_SAKICK	"SAKICK"
#define MSG_SAMODE	"SAMODE"
#define MSG_SATOPIC	"SATOPIC"
#define MSG_SERVER	"SERVER"
#define MSG_SGLINE	"SGLINE"
#define MSG_SILENCE	"SILENCE"
#define MSG_SJOIN	"SJOIN"
#define MSG_SNICK	"SNICK"
#define MSG_SQLINE	"SQLINE"
#define MSG_SQUIT	"SQUIT"
#define MSG_STATS	"STATS"
#define MSG_SVINFO	"SVINFO"
#define MSG_SVSHOLD	"SVSHOLD"
#define MSG_SVSKILL	"SVSKILL"
#define MSG_SVSMODE	"SVSMODE"
#define MSG_SVSNICK	"SVSNICK"
#define MSG_SVSNOOP	"SVSNOOP"
#define MSG_SZLINE	"SZLINE"
#define MSG_TIME	"TIME"
#define MSG_TOPIC	"TOPIC"
#define MSG_TRACE	"TRACE"
#define MSG_UNKLINE	"UNKLINE"
#define MSG_UNSGLINE	"UNSGLINE"
#define MSG_UNSQLINE	"UNSQLINE"
#define MSG_UNSZLINE	"UNSZLINE"
#define MSG_USER	"USER"
#define MSG_USERHOST	"USERHOST"
#define MSG_VERSION	"VERSION"
#define MSG_VHOST	"VHOST"
#define MSG_WALLOPS	"WALLOPS"
#define MSG_WATCH	"WATCH"
#define MSG_WHO		"WHO"
#define MSG_WHOIS	"WHOIS"
#define MSG_WHOWAS	"WHOWAS"

#define TOK1_SVSKILL	"1"
#define TOK1_SVSMODE	"2"
#define TOK1_SVSNICK	"3"
#define TOK1_SVSNOOP	"4"
#define TOK1_SGLINE	"5"
#define TOK1_UNSGLINE	"6"
#define TOK1_SVSHOLD	"7"
#define TOK1_STATS	"?"
#define TOK1_AWAY	"A"
#define TOK1_BURST	"B"
#define TOK1_CHATOPS	"C"
#define TOK1_ERROR	"E"
#define TOK1_GNOTICE	"G"
#define TOK1_INVITE	"I"
#define TOK1_JOIN	"J"
#define TOK1_KICK	"K"
#define TOK1_GLOBOPS	"L"
#define TOK1_MODE	"M"
#define TOK1_NICK	"N"
#define TOK1_PRIVMSG	"P"
#define TOK1_PRIVMSG_D	"["
#define TOK1_QUIT	"Q"
#define TOK1_RAKILL	"R"
#define TOK1_SJOIN	"S"
#define TOK1_TOPIC	"T"
#define TOK1_UNSQLINE	"U"
#define TOK1_WHOIS	"W"
#define TOK1_VHOST	"V"
#define TOK1_AKILL	"a"
#define TOK1_CONNECT	"c"
#define TOK1_ADMIN	"d"
#define TOK1_SNICK	"e"
#define TOK1_PING	"f"
#define TOK1_TIME	"i"
#define TOK1_KILL	"k"
#define TOK1_WALLOPS	"l"
#define TOK1_MOTD	"m"
#define TOK1_NOTICE	"n"
#define TOK1_NOTICE_D	"]"
#define TOK1_PART	"p"
#define TOK1_SQUIT	"q"
#define TOK1_RESYNCH	"r"
#define TOK1_SERVER	"s"
#define TOK1_TRACE	"t"
#define TOK1_PONG	"u"
#define TOK1_VERSION	"v"
#define TOK1_WHOWAS	"w"
#define TOK1_SQLINE	"x"
#define TOK1_SVINFO	"z"

extern int m_kline(aClient *, aClient *, int, char **);
extern int m_unkline(aClient *, aClient *, int, char **);
extern int m_akill(aClient *, aClient *, int, char **);
extern int m_rakill(aClient *, aClient *, int, char **);
extern int m_locops(aClient *, aClient *, int, char **);
extern int m_privmsg(aClient *, aClient *, int, char **);
extern int m_privmsg_direct(aClient *, aClient *, int, char **);
extern int m_topic(aClient *, aClient *, int, char **);
extern int m_join(aClient *, aClient *, int, char **);
extern int m_part(aClient *, aClient *, int, char **);
extern int m_mode(aClient *, aClient *, int, char **);
extern int m_ping(aClient *, aClient *, int, char **);
extern int m_pong(aClient *, aClient *, int, char **);
extern int m_wallops(aClient *, aClient *, int, char **);
extern int m_kick(aClient *, aClient *, int, char **);
extern int m_nick(aClient *, aClient *, int, char **);
extern int m_error(aClient *, aClient *, int, char **);
extern int m_notice(aClient *, aClient *, int, char **);
extern int m_notice_direct(aClient *, aClient *, int, char **);
extern int m_invite(aClient *, aClient *, int, char **);
extern int m_quit(aClient *, aClient *, int, char **);
extern int m_kill(aClient *, aClient *, int, char **);
extern int m_who(aClient *, aClient *, int, char **);
extern int m_whois(aClient *, aClient *, int, char **);
extern int m_user(aClient *, aClient *, int, char **);
extern int m_list(aClient *, aClient *, int, char **);
extern int m_server(aClient *, aClient *, int, char **);
extern int m_info(aClient *, aClient *, int, char **);
extern int m_links(aClient *, aClient *, int, char **);
extern int m_summon(aClient *, aClient *, int, char **);
extern int m_stats(aClient *, aClient *, int, char **);
extern int m_chanserv(aClient *, aClient *, int, char **);
extern int m_nickserv(aClient *, aClient *, int, char **);
extern int m_operserv(aClient *, aClient *, int, char **);
extern int m_statserv(aClient *, aClient *, int, char **);
extern int m_memoserv(aClient *, aClient *, int, char **);
extern int m_services(aClient *, aClient *, int, char **);
extern int m_identify(aClient *, aClient *, int, char **);
extern int m_svsnick(aClient *, aClient *, int, char **);
extern int m_svsnoop(aClient *, aClient *, int, char **);
extern int m_svskill(aClient *, aClient *, int, char **);
extern int m_svsmode(aClient *, aClient *, int, char **);
extern int m_version(aClient *, aClient *, int, char **);
extern int m_squit(aClient *, aClient *, int, char **);
extern int m_away(aClient *, aClient *, int, char **);
extern int m_connect(aClient *, aClient *, int, char **);
extern int m_oper(aClient *, aClient *, int, char **);
extern int m_pass(aClient *, aClient *, int, char **);
extern int m_trace(aClient *, aClient *, int, char **);
extern int m_time(aClient *, aClient *, int, char **);
extern int m_names(aClient *, aClient *, int, char **);
extern int m_admin(aClient *, aClient *, int, char **);
extern int m_lusers(aClient *, aClient *, int, char **);
extern int m_close(aClient *, aClient *, int, char **);
extern int m_whowas(aClient *, aClient *, int, char **);
extern int m_userhost(aClient *, aClient *, int, char **);
extern int m_ison(aClient *, aClient *, int, char **);
extern int m_svinfo(aClient *, aClient *, int, char **);
extern int m_sjoin(aClient *, aClient *, int, char **);
extern int m_samode(aClient *, aClient *, int, char **);
extern int m_globops(aClient *, aClient *, int, char **);
extern int m_chatops(aClient *, aClient *, int, char **);
extern int m_goper(aClient *, aClient *, int, char **);
extern int m_gnotice(aClient *, aClient *, int, char **);
extern int m_rehash(aClient *, aClient *, int, char **);
extern int m_restart(aClient *, aClient *, int, char **);
extern int m_die(aClient *, aClient *, int, char **);
extern int m_hash(aClient *, aClient *, int, char **);
extern int m_capab(aClient *, aClient *, int, char **);
extern int m_silence(aClient *, aClient *, int, char **);
extern int m_watch(aClient *, aClient *, int, char **);
extern int m_sqline(aClient *, aClient *, int, char **);
extern int m_unsqline(aClient *, aClient *, int, char **);
extern int m_burst(aClient *, aClient *, int, char **);
extern int m_dccallow(aClient *, aClient *, int, char **);
extern int m_dkey(aClient *, aClient *, int, char **);
extern int m_motd(aClient *, aClient *, int, char **);
extern int m_opermotd(aClient *, aClient *, int, char **);
extern int m_rules(aClient *, aClient *, int, char **);
extern int m_dalinfo(aClient *, aClient *, int, char **);
#ifndef STATIC_MODULES
extern int m_module(aClient *, aClient *, int, char **);
#endif
extern int m_map(aClient *, aClient *, int, char **);
extern int m_mkpasswd(aClient *, aClient *, int, char **);
extern int m_vhost(aClient *, aClient *, int, char **);
extern int m_knock(aClient *, aClient *, int, char **);
extern int m_sgline(aClient *, aClient *, int, char **);
extern int m_unsgline(aClient *, aClient *, int, char **);
extern int m_accept(aClient *, aClient *, int, char **);
extern int m_sajoin(aClient *, aClient *, int, char **);
extern int m_sakick(aClient *, aClient *, int, char **);
extern int m_szline(aClient *, aClient*, int, char **);
extern int m_unszline(aClient *, aClient *, int, char **);
extern int m_snick(aClient *, aClient *, int, char **);
extern int m_myid(aClient *, aClient *, int, char **);
extern int m_hostserv(aClient *, aClient *, int, char **);
extern int m_resynch(aClient *, aClient *, int, char **);
extern int m_botserv(aClient *, aClient *, int, char **);
extern int m_satopic(aClient *, aClient *, int, char **);
extern int m_svshold(aClient *, aClient *, int, char **);

#include "msgptr.h"

#endif /* __msg_include__ */
