/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_kick.c,v 1.34.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "send.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_kick) = {
	"m_kick",
	"/KICK command",
	6, "$Revision: 1.34.2.2 $"
};

int MOD_LOAD(m_kick)()
{
	if (register_command(&MOD_HEADER(m_kick), &CMD_KICK, m_kick) == NULL) {
		return MOD_FAILURE;
	}
	MOD_SET_FLAG(&MOD_HEADER(m_kick), MOD_FLAG_PERM);
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_kick)()
{
	return MOD_SUCCESS;
}

/*
 * m_kick
 *	parv[0] = sender prefix
 *	parv[1] = channel list
 *	parv[2] = client list
 *	parv[3] = comment
 */
int m_kick(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr = NULL;
	aChannel *chptr = NULL;
	char *name, *user, *p = NULL, *p2 = NULL;
	char *comment = (parc > 3 && *parv[3] != '\0') ? parv[3] : parv[0];

	if (parc < 3 || *parv[1] == '\0') {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "KICK");
		return 0;
	}

	if (strlen(comment) > TOPICLEN) {
		comment[TOPICLEN] = '\0';
	}

	for (; (name = strtoken(&p, parv[1], ",")); parv[1] = NULL) {
		if ((chptr = find_channel(name, NULL)) == NULL) {
			send_me_numeric(sptr, ERR_NOSUCHCHANNEL, name);
			continue;
		}
		if (!IsServer(cptr) && !is_chanop(sptr, chptr) && !is_halfop(sptr, chptr) && !IsULine(sptr)) {
			if (MyConnect(sptr) || !chptr->channelts) {
				send_me_numeric(sptr, ERR_CHANOPRIVSNEEDED, chptr->chname);
				continue;
			}
		}

		for (; (user = strtoken(&p2, parv[2], ",")); parv[2] = NULL) {
			if ((acptr = IsServer(cptr) ? find_target_chasing(sptr, user, MSG_KICK) :
			  find_chasing(sptr, user, NULL, MSG_KICK)) == NULL) {
				continue;
			}
			if (!IsMember(acptr, chptr)) {
				send_me_numeric(sptr, ERR_USERNOTINCHANNEL, user, name);
				continue;
			}
			if (!IsServer(cptr) && !IsULine(sptr)) {
				if (!is_chanadmin(sptr, chptr) && is_chanadmin(acptr, chptr)) {
					send_me_notice(sptr, ":Cannot kick channel administrator %s", user);
					continue;
				}
				if (is_halfop(sptr, chptr) && !is_chanop(sptr, chptr) && is_chanop(acptr, chptr)) {
					send_me_notice(sptr, ":Cannot kick channel operator %s", user);
					continue;
				}
			}

			sendto_channel_local_msg_butone(NULL, sptr, chptr, ALL_MEMBERS, &CMD_KICK,
				"%s %s :%s", chptr->chname, acptr->name, comment);

			sendto_serv_capab_msg_butone(cptr, sptr, NO_CAPS, ID_CAPS, &CMD_KICK,
				"%s %s :%s", chptr->chname, acptr->name, comment);
			sendto_serv_capab_msg_butone(cptr, sptr, ID_CAPS, NO_CAPS, &CMD_KICK,
				"%s %s :%s", chptr->chname, get_id(acptr), comment);

			remove_user_from_channel(acptr, chptr);
		}
	}

	return 0;
}
