/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_silence.c,v 1.22.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_silence) = {
	"m_silence",
	"/SILCENCE command",
	6, "$Revision: 1.22.2.2 $"
};

int MOD_LOAD(m_silence)()
{
	if (register_command(&MOD_HEADER(m_silence), &CMD_SILENCE, m_silence) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_silence)()
{
	return MOD_SUCCESS;
}

/*
 * m_silence
 *	parv[0] = sender prefix
 *	If local client:
 *		parv[1] = mask (NULL sends the list)
 *	If remote client:
 *		parv[1] = nick to be silenced
 *		parv[2] = mask
 */
int m_silence(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr = NULL;
	SLink *lp;
	char c, *cp;

	if (MyClient(sptr)) {
		acptr = sptr;
		if (parc < 2 || *parv[1] == '\0' || (acptr = find_person(parv[1], NULL)) != NULL) {
			if (acptr->user == NULL) {
				return 0;
			}
			for (lp = acptr->user->silence; lp != NULL; lp = lp->next) {
				send_me_numeric(sptr, RPL_SILELIST, acptr->name, lp->value.cp);
			}
			send_me_numericNA(sptr, RPL_ENDOFSILELIST);
			return 0;
		}

		cp = parv[1];
		c = *cp;

		if (c == '-' || (c == '+')) {
			cp++;
		}
		else if (!(strchr(cp, '@') || strchr(cp, '.') || strchr(cp, '!') || strchr(cp, '*'))) {
			target_left(sptr, parv[1], MSG_SILENCE, NULL);
			return 0;
		}
		else {
			c = '+';
		}

		cp = pretty_mask(cp);
		if ((c == '-' && !del_silence(sptr, cp)) || (c != '-' && !add_silence(sptr, cp))) {
			sendto_one_client_prefixed(sptr, sptr, &CMD_SILENCE, "%c%s", c, cp);

			if (c == '-') {
				sendto_serv_msg_butone(cptr, sptr, &CMD_SILENCE, "* -%s", cp);
			}
		}
	}
	else if (parc < 3 || *parv[2] == '\0') {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "SILENCE");
	}
	else if ((c = *parv[2]) == '-' || (acptr = find_person(parv[1], NULL)) != NULL) {
		if (c == '-') {
			if (!del_silence(sptr, parv[2] + 1)) {
				sendto_serv_msg_butone(cptr, sptr, &CMD_SILENCE, "%s %s",
					parv[1], parv[2]);
			}
		}
		else {
			add_silence(sptr, parv[2]);
			if (!MyClient(acptr)) {
				sendto_one_client(acptr, sptr, &CMD_SILENCE, "%s", parv[2]);
			}
		}
	}
	return 0;
}
