/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: match.c,v 1.27.2.1 2004/12/07 03:05:14 pneumatus Exp $
 */

#include "struct.h"
#include "common.h"
#include "sys.h"
#include "memory.h"
#include "h.h"

#define MAX_MATCH_CYCLES 512

/* Originally by Douglas A Lewis (dalewis@acsu.buffalo.edu) */
int match(char *mask, char *name)
{
	const unsigned char *m = (const unsigned char *)mask;
	const unsigned char *ma = (const unsigned char *)mask;
	const unsigned char *n =(const unsigned char *)name;
	const unsigned char *na =(const unsigned char *)name;
	int calls = 0, wild = 0;

	ASSERT(mask != NULL);
	ASSERT(name != NULL);

	while (calls++ < MAX_MATCH_CYCLES) {
		if (*m == '*') {
			while (*m == '*') {
				m++;
			}
			wild = 1;
			ma = m;
			na = n;
		}
		if (*m == '\0') {
			if (*n == '\0') {
				return 0;
			}

			for (m--; (m > (const unsigned char *)mask) && (*m == '?'); m--)
				;
			if (*m == '*' && (m > (const unsigned char *)mask)) {
				return 0;
			}
			if (!wild) {
				return 1;
			}

			m = ma;
			n = ++na;
		}
		else if (*n == '\0') {
			while (*m == '*') {
				m++;
			}
			return (*m != '\0');
		}

		if ((ToLower(*m) != ToLower(*n)) && (*m != '?')) {
			if (!wild) {
				return 1;
			}
			m = ma;
			n = ++na;
		}
		else {
			if (*m != '\0') {
				m++;
			}
			if (*n != '\0') {
				n++;
			}
		}
	}
	return 1;
}

char *collapse(char *ptr)
{
	char *s, *s1, *t;

	if (ptr == NULL) {
		return NULL;
	}

	for (s = ptr; *s != '\0'; s++) {
		if (*s != '*') {
			continue;
		}

		t = s1 = s + 1;
		while (*t == '*') {
			t++;
		}
		if (s1 != t) {
			while ((*s1++ = *t++));
		}
	}
	return ptr;
}

const unsigned char tolower_table[] = {
	0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
	0xb, 0xc, 0xd, 0xe, 0xf, 0x10, 0x11, 0x12, 0x13, 0x14,
	0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d,
	0x1e, 0x1f,
	' ', '!', '"', '#', '$', '%', '&', 0x27, '(', ')',
	'*', '+', ',', '-', '.', '/',
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	':', ';', '<', '=', '>', '?',
	'@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i',
	'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's',
	't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^',
	'_',
	'`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i',
	'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's',
	't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~',
	0x7f,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89,
	0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99,
	0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9,
	0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9,
	0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9,
	0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9,
	0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9,
	0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9,
	0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
};

const unsigned char toupper_table[] = {
	0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa,
	0xb, 0xc, 0xd, 0xe, 0xf, 0x10, 0x11, 0x12, 0x13, 0x14,
	0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d,
	0x1e, 0x1f,
	' ', '!', '"', '#', '$', '%', '&', 0x27, '(', ')',
	'*', '+', ',', '-', '.', '/',
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	':', ';', '<', '=', '>', '?',
	'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
	'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S',
	'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^',
	0x5f,
	'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
	'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S',
	'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~',
	0x7f,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89,
	0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99,
	0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9,
	0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9,
	0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9,
	0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9,
	0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9,
	0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9,
	0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
};

const unsigned int charattr_table[] = {
/* 0  */	C_CNTRL,
/* 1  */	C_CNTRL | C_CHAN,
/* 2  */	C_CNTRL | C_CHAN | C_FCHAN,
/* 3  */	C_CNTRL | C_CHAN | C_FCHAN,
/* 4  */	C_CNTRL | C_CHAN,
/* 5  */	C_CNTRL | C_CHAN,
/* 6  */	C_CNTRL | C_CHAN,
/* 7 BEL */	C_CNTRL,
/* 8  \b */	C_CNTRL | C_CHAN,
/* 9  \t */	C_CNTRL | C_SPACE | C_CHAN,
/* 10 \n */	C_CNTRL | C_SPACE | C_CHAN | C_EOL,
/* 11 \v */	C_CNTRL | C_SPACE | C_CHAN,
/* 12 \f */	C_CNTRL | C_SPACE | C_CHAN,
/* 13 \r */	C_CNTRL | C_SPACE | C_CHAN | C_EOL,
/* 14 */	C_CNTRL | C_CHAN,
/* 15 */	C_CNTRL | C_CHAN,
/* 16 */	C_CNTRL | C_CHAN,
/* 17 */	C_CNTRL | C_CHAN,
/* 18 */	C_CNTRL | C_CHAN,
/* 19 */	C_CNTRL | C_CHAN,
/* 20 */	C_CNTRL | C_CHAN,
/* 21 */	C_CNTRL | C_CHAN,
/* 22 */	C_CNTRL | C_CHAN | C_FCHAN,
/* 23 */	C_CNTRL | C_CHAN,
/* 24 */	C_CNTRL | C_CHAN,
/* 25 */	C_CNTRL | C_CHAN,
/* 26 */	C_CNTRL | C_CHAN,
/* 27 */	C_CNTRL | C_CHAN,
/* 28 */	C_CNTRL | C_CHAN,
/* 29 */	C_CNTRL | C_CHAN,
/* 30 */	C_CNTRL | C_CHAN,
/* 31 */	C_CNTRL | C_CHAN | C_FCHAN,
/* SP */	C_PRINT | C_SPACE,
/* ! */		C_PRINT | C_CHAN,
/* " */		C_PRINT | C_CHAN,
/* # */		C_PRINT | C_CHANP | C_CHAN,
/* $ */		C_PRINT | C_CHAN | C_USER,
/* % */		C_PRINT | C_CHAN | C_NICKP,
/* & */		C_PRINT | C_CHANP | C_CHAN,
/* ' */		C_PRINT | C_CHAN,
/* ( */		C_PRINT | C_CHAN,
/* ) */		C_PRINT | C_CHAN,
/* * */		C_PRINT | C_WILD | C_CHAN | C_SERV | C_NICKP,
/* + */		C_PRINT | C_CHAN | C_NICKP,
/* , */		C_PRINT,
/* - */		C_PRINT | C_NICK | C_CHAN | C_USER | C_HOST,
/* . */		C_PRINT | C_CHAN | C_USER | C_HOST | C_SERV,
/* / */		C_PRINT | C_CHAN,
/* 0 */		C_PRINT | C_DIGIT | C_NICK | C_CHAN | C_USER | C_HOST,
/* 1 */		C_PRINT | C_DIGIT | C_NICK | C_CHAN | C_USER | C_HOST,
/* 2 */		C_PRINT | C_DIGIT | C_NICK | C_CHAN | C_USER | C_HOST,
/* 3 */ 	C_PRINT | C_DIGIT | C_NICK | C_CHAN | C_USER | C_HOST,
/* 4 */ 	C_PRINT | C_DIGIT | C_NICK | C_CHAN | C_USER | C_HOST,
/* 5 */		C_PRINT | C_DIGIT | C_NICK | C_CHAN | C_USER | C_HOST,
/* 6 */		C_PRINT | C_DIGIT | C_NICK | C_CHAN | C_USER | C_HOST,
/* 7 */		C_PRINT | C_DIGIT | C_NICK | C_CHAN | C_USER | C_HOST,
/* 8 */		C_PRINT | C_DIGIT | C_NICK | C_CHAN | C_USER | C_HOST,
/* 9 */		C_PRINT | C_DIGIT | C_NICK | C_CHAN | C_USER | C_HOST,
/* : */		C_PRINT | C_CHAN | C_HOST,
/* ; */		C_PRINT | C_CHAN,
/* < */		C_PRINT | C_CHAN,
/* = */		C_PRINT | C_CHAN,
/* > */		C_PRINT | C_CHAN,
/* ? */		C_PRINT | C_WILD | C_CHAN,
/* @ */		C_PRINT | C_CHAN | C_NICKP,
/* A */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* B */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* C */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* D */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* E */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* F */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* G */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* H */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* I */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* J */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* K */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* L */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* M */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* N */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* O */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* P */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* Q */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* R */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* S */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* T */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* U */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* V */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* W */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* X */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* Y */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* Z */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* [ */		C_PRINT | C_ALPHA | C_NICK | C_CHAN | C_USER,
/* \ */		C_PRINT | C_ALPHA | C_NICK | C_CHAN | C_USER,
/* ] */		C_PRINT | C_ALPHA | C_NICK | C_CHAN | C_USER,
/* ^ */		C_PRINT | C_ALPHA | C_NICK | C_CHAN | C_USER,
/* _ */		C_PRINT | C_NICK | C_CHAN | C_USER,
/* ` */		C_PRINT | C_NICK | C_CHAN | C_USER,
/* a */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* b */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* c */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* d */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* e */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* f */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* g */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* h */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* i */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* j */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* k */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* l */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* m */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* n */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* o */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* p */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* q */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* r */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* s */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* t */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* u */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* v */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* w */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* x */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* y */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* z */		C_PRINT | C_ALPHA | C_LET | C_NICK | C_CHAN | C_USER | C_HOST,
/* { */		C_PRINT | C_ALPHA | C_NICK | C_CHAN | C_USER,
/* | */		C_PRINT | C_ALPHA | C_NICK | C_CHAN | C_USER,
/* } */		C_PRINT | C_ALPHA | C_NICK | C_CHAN | C_USER,
/* ~ */		C_PRINT | C_ALPHA | C_CHAN | C_USER,
/* del  */	C_CHAN,
/* 0x80 */	C_CHAN,
/* 0x81 */	C_CHAN,
/* 0x82 */	C_CHAN,
/* 0x83 */	C_CHAN,
/* 0x84 */	C_CHAN,
/* 0x85 */	C_CHAN,
/* 0x86 */	C_CHAN,
/* 0x87 */	C_CHAN,
/* 0x88 */	C_CHAN,
/* 0x89 */	C_CHAN,
/* 0x8A */	C_CHAN,
/* 0x8B */	C_CHAN,
/* 0x8C */	C_CHAN,
/* 0x8D */	C_CHAN,
/* 0x8E */	C_CHAN,
/* 0x8F */	C_CHAN,
/* 0x90 */	C_CHAN,
/* 0x91 */	C_CHAN,
/* 0x92 */	C_CHAN,
/* 0x93 */	C_CHAN,
/* 0x94 */	C_CHAN,
/* 0x95 */	C_CHAN,
/* 0x96 */	C_CHAN,
/* 0x97 */	C_CHAN,
/* 0x98 */	C_CHAN,
/* 0x99 */	C_CHAN,
/* 0x9A */	C_CHAN,
/* 0x9B */	C_CHAN,
/* 0x9C */	C_CHAN,
/* 0x9D */	C_CHAN,
/* 0x9E */	C_CHAN,
/* 0x9F */	C_CHAN,
/* 0xA0 */	C_CHAN | C_FCHAN,
/* 0xA1 */	C_CHAN,
/* 0xA2 */	C_CHAN,
/* 0xA3 */	C_CHAN,
/* 0xA4 */	C_CHAN,
/* 0xA5 */	C_CHAN,
/* 0xA6 */	C_CHAN,
/* 0xA7 */	C_CHAN,
/* 0xA8 */	C_CHAN,
/* 0xA9 */	C_CHAN,
/* 0xAA */	C_CHAN,
/* 0xAB */	C_CHAN,
/* 0xAC */	C_CHAN,
/* 0xAD */	C_CHAN,
/* 0xAE */	C_CHAN,
/* 0xAF */	C_CHAN,
/* 0xB0 */	C_CHAN,
/* 0xB1 */	C_CHAN,
/* 0xB2 */	C_CHAN,
/* 0xB3 */	C_CHAN,
/* 0xB4 */	C_CHAN,
/* 0xB5 */	C_CHAN,
/* 0xB6 */	C_CHAN,
/* 0xB7 */	C_CHAN,
/* 0xB8 */	C_CHAN,
/* 0xB9 */	C_CHAN,
/* 0xBA */	C_CHAN,
/* 0xBB */	C_CHAN,
/* 0xBC */	C_CHAN,
/* 0xBD */	C_CHAN,
/* 0xBE */	C_CHAN,
/* 0xBF */	C_CHAN,
/* 0xC0 */	C_CHAN,
/* 0xC1 */	C_CHAN,
/* 0xC2 */	C_CHAN,
/* 0xC3 */	C_CHAN,
/* 0xC4 */	C_CHAN,
/* 0xC5 */	C_CHAN,
/* 0xC6 */	C_CHAN,
/* 0xC7 */	C_CHAN,
/* 0xC8 */	C_CHAN,
/* 0xC9 */	C_CHAN,
/* 0xCA */	C_CHAN,
/* 0xCB */	C_CHAN,
/* 0xCC */	C_CHAN,
/* 0xCD */	C_CHAN,
/* 0xCE */	C_CHAN,
/* 0xCF */	C_CHAN,
/* 0xD0 */	C_CHAN,
/* 0xD1 */	C_CHAN,
/* 0xD2 */	C_CHAN,
/* 0xD3 */	C_CHAN,
/* 0xD4 */	C_CHAN,
/* 0xD5 */	C_CHAN,
/* 0xD6 */	C_CHAN,
/* 0xD7 */	C_CHAN,
/* 0xD8 */	C_CHAN,
/* 0xD9 */	C_CHAN,
/* 0xDA */	C_CHAN,
/* 0xDB */	C_CHAN,
/* 0xDC */	C_CHAN,
/* 0xDD */	C_CHAN,
/* 0xDE */	C_CHAN,
/* 0xDF */	C_CHAN,
/* 0xE0 */	C_CHAN,
/* 0xE1 */	C_CHAN,
/* 0xE2 */	C_CHAN,
/* 0xE3 */	C_CHAN,
/* 0xE4 */	C_CHAN,
/* 0xE5 */	C_CHAN,
/* 0xE6 */	C_CHAN,
/* 0xE7 */	C_CHAN,
/* 0xE8 */	C_CHAN,
/* 0xE9 */	C_CHAN,
/* 0xEA */	C_CHAN,
/* 0xEB */	C_CHAN,
/* 0xEC */	C_CHAN,
/* 0xED */	C_CHAN,
/* 0xEE */	C_CHAN,
/* 0xEF */	C_CHAN,
/* 0xF0 */	C_CHAN,
/* 0xF1 */	C_CHAN,
/* 0xF2 */	C_CHAN,
/* 0xF3 */	C_CHAN,
/* 0xF4 */	C_CHAN,
/* 0xF5 */	C_CHAN,
/* 0xF6 */	C_CHAN,
/* 0xF7 */	C_CHAN,
/* 0xF8 */	C_CHAN,
/* 0xF9 */	C_CHAN,
/* 0xFA */	C_CHAN,
/* 0xFB */	C_CHAN,
/* 0xFC */	C_CHAN,
/* 0xFD */	C_CHAN,
/* 0xFE */	C_CHAN,
/* 0xFF */	C_CHAN
};

int mycmp(char *s1, char *s2)
{
	unsigned char *str1 = (unsigned char *)s1;
	unsigned char *str2 = (unsigned char *)s2;

	ASSERT(str1 != NULL);
	ASSERT(str2 != NULL);

	while (ToUpper(*str1) == ToUpper(*str2)) {
		if (*str1 == '\0') {
			return 0;
		}
		str1++;
		str2++;
	}

	return 1;
}

int irccmp(char *s1, char *s2)
{
	unsigned char *str1 = (unsigned char *)s1;
	unsigned char *str2 = (unsigned char *)s2;

	ASSERT(str1 != NULL);
	ASSERT(str2 != NULL);

	while (*str1 == *str2) {
		if (*str1 == '\0') {
			return 0;
		}
		str1++;
		str2++;
	}

	return 1;
}

int myncmp(char *s1, char *s2, int n)
{
	unsigned char *str1 = (unsigned char *)s1;
	unsigned char *str2 = (unsigned char *)s2;

	ASSERT(str1 != NULL);
	ASSERT(str2 != NULL);

	while (ToUpper(*str1) == ToUpper(*str2)) {
		str1++;
		str2++;
		n--;
		if (!n || (*str1 == '\0' && *str2 == '\0')) {
			return 0;
		}
	}

	return 1;
}

int ircncmp(char *s1, char *s2, int n)
{
	unsigned char *str1 = (unsigned char *)s1;
	unsigned char *str2 = (unsigned char *)s2;

	ASSERT(str1 != NULL);
	ASSERT(str2 != NULL);

	while (*str1 == *str2) {
		str1++;
		str2++;
		n--;
		if (n == 0 || (*str1 == '\0' && *str2 == '\0')) {
			return 0;
		}
	}

	return 1;
}
