#!/bin/sh
# $Id: version.c.SH,v 1.44.2.4 2005/04/14 21:41:22 amcwilliam Exp $

printf "Extracting version information... "

if test -f "../.build"; then
	revision="`grep ':' ../.build`"
else
	revision="UNKNOWN"
fi
printf "revision $revision"

if test -r version.c.last; then
	compile_number="`sed -n 's/^char \*compile_number = \"\(.*\)\";/\1/p' < version.c.last`"
	if test "x$compile_number" = "x"; then
		compile_number=0
	fi
else
	compile_number=0
fi
compile_number="`expr $compile_number + 1`"
printf ", compile #$compile_number"

creation=`date | awk '{ if (NF == 6) { print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } else \
	{ print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`
printf ", generated $creation.\n"

if test -f "version.c"; then
	rm -f version.c
fi

cat >>version.c<<__EOF__
/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 */

#include "struct.h"
#include "patchlevel.h"

char *compile_number = "$compile_number";
char *creation = "$creation";
char *revision = "$revision";
char ircd_version[128];

char *infotext[] =
{
	"RageIRCd: an advanced Internet Relay Chat daemon (ircd).",
	"(C) 2000-2005 the RageIRCd Development Team, all rights reserved.",
	" ",
	"This software is free, licensed under the General Public License.",
	"Please refer to doc/LICENSE and doc/README for further details.",
	" ",
	"The main people behind RageIRCd v2.0 are ^Th3Dud3^, Pneu and Dogbert.",
	" ",
	"Thanks must go to Acidic32, Asmodai, StrikerST, Raider, Stinger^,",
	"Jamie, fox, Rob, paul, Chris, geggy, Trystan and GenuisDex who have",
	"contributed ideas and/or support to the RageIRCd project.",
	" ",
	"RageIRCd v2.0 also contains code developed or influenced by:",
	"  ShadowMaster (shadowmaster@shadow-realm.org)",
	"  Stskeeps (stskeeps@unrealircd.com)",
	"  codemastr (codemastr@unrealircd.com)",
	"  binary (garryb@binary.islesfan.net)",
	"  GZ (gz@ircsystems.net)",
	"  skold (skold@habber.net)",
	"  lucas (lucas@negaverse.org)",
	"  White_Dragon (wd@dal.net)",
	"  Dianora (db@koruna.varner.com)",
	"  epiphani (epiphani@dal.net)",
	"  codestud & moogle",
	"  sedition (sedition@dal.net)",
	" ",
	"Apologies to anyone who feels they deserve to be on the above list, but",
	"have been missed off. I'm sure it wasn't intentional. Report it as a",
	"bug and it will get fixed.",
	" ",
	0,
};

char *dalinfotext[] =
{
	"The following people have contributed code, or support",
	"to the bahamut team:",
	"aClient             Diane Bruce         db@koruna.varner.com",
	"Dakal               David Knepper       dakal@dal.net",
	"Dalvenjah           Sven Nielsen        dalvenjah@dal.net",
	"Epiphani            Aaron Wiebe         epiphani@dal.net",
	"lucas               Lucas Madar         lucas@negaverse.org",
	"MSofty              Mark Salerno        msofty@dal.net",
	"Raistlin_Mejere     Jason Slagle        raistlin@bahamut.net",
	"Rakarra             Ian Westcott        rakarra@dal.net",
	"sedition            David Parton        sedition@dal.net",
	"White_Dragon        Chip Norkus         wd@dal.net",
	" ",
	"The following people have contributed ideas or testing to the",
	"bahamut project:",
	"driz                David Friedman      driz@dal.net",
	"habit               Melinda Thompson    habit@dal.net",
	"Kevin               Kevin Turner        kevin@dal.net",
	" ",
	"Developers and Contributors for previous versions:",
	" ",
	"Chris A. Bongaarts  Chris Behrens       Diane Bruce",
	"Johannes Erdfelt    Roger Espel Llima   Jon Lusky",
	"Michael Pearce      Brian Kraemer       Joan Touzet",
	"Chris Portman       Keith Fralick       Sam Noble",
	"Taner Halicioglu    Chris Behrens       Darren Reed",
	"Markku Savela       Greg Lindahl        Jarkko Oikarinen",
	"Armin Gruner        Matthew Green       Chuck Kane",
	"Matt Lyle           Vesa Ruokonen       Nicolas PIOCH",
	"Stellan Klebom      Dan Goodwin         Mike Bolotski",
	"Ian Frechette       Markku Jarvinen     Kimmo Suominen",
	"Jeff Trim           Vijay Subramaniam   Karl Kleinpaste",
	"Bill Wisner         Tom Davis           Hugo Calendar",
	"Tom Hopkins         Stephen van den Berg",
	"Bo Adler            Michael Sandrof     Jon Solomon",
	"Jan Peterson        Helen Rose          Paul Graham",
	" ",
	"Thanks also goes to those persons not mentioned here who have added",
	"their advice, opinions, and code to IRC.",
	"Thanks also to those who provide the kind sys admins who let me and",
	"others continue to develop IRC.",
	"Thanks also to those who continue to make twinkies and doritos, as they",
	"are the backbone of most programmers' diets and thus make it possible",
	"for code like this to be developed!",
	" ",
	0,
};
__EOF__
