#!/usr/bin/perl
# Copyright (C) 2008-2009, The Perl Foundation.
# $Id$

use strict;
use warnings;

my @prop = qw(
    Alphabetic
    Any
    Arabic
    Armenian
    ASCIIHexDigit
    Assigned
    Bengali
    BidiEN
    BidiES
    BidiET
    BidiL
    BidiWS
    Bopomofo
    Buhid
    C
    CanadianAboriginal
    Cc
    Cf
    Cherokee
    ClosePunctuation
    Common
    ConnectorPunctuation
    Control
    CurrencySymbol
    Cyrillic
    Dash
    DashPunctuation
    DecimalNumber
    Deseret
    Devanagari
    Diacritic
    EnclosingMark
    Ethiopic
    Extender
    FinalPunctuation
    Format
    Georgian
    Gothic
    GraphemeLink
    Greek
    Gujarati
    Gurmukhi
    Han
    Hangul
    Hanunoo
    Hebrew
    HexDigit
    Hiragana
    Hyphen
    ID_Continue
    Ideographic
    IDSBinaryOperator
    ID_Start
    IDSTrinaryOperator
    InAlphabeticPresentationForms
    InArabic
    InArabicPresentationFormsA
    InArabicPresentationFormsB
    InArmenian
    InArrows
    InBasicLatin
    InBengali
    InBlockElements
    InBopomofo
    InBopomofoExtended
    InBoxDrawing
    InBraillePatterns
    InBuhid
    InByzantineMusicalSymbols
    InCherokee
    InCJKCompatibility
    InCJKCompatibilityForms
    InCJKCompatibilityIdeographs
    InCJKCompatibilityIdeographsSupplement
    InCJKRadicalsSupplement
    InCJKSymbolsAndPunctuation
    InCJKUnifiedIdeographs
    InCJKUnifiedIdeographsExtensionA
    InCJKUnifiedIdeographsExtensionB
    InCombiningDiacriticalMarks
    InCombiningDiacriticalMarksforSymbols
    InCombiningHalfMarks
    InControlPictures
    InCurrencySymbols
    InCyrillic
    InCyrillicSupplementary
    InDeseret
    InDevanagari
    InDingbats
    InEnclosedAlphanumerics
    InEnclosedCJKLettersAndMonths
    InEthiopic
    InGeneralPunctuation
    InGeometricShapes
    InGeorgian
    InGothic
    InGreekAndCoptic
    InGreekExtended
    InGujarati
    InGurmukhi
    InHalfwidthAndFullwidthForms
    InHangulCompatibilityJamo
    InHangulJamo
    InHangulSyllables
    InHanunoo
    InHebrew
    Inherited
    InHighPrivateUseSurrogates
    InHighSurrogates
    InHiragana
    InIdeographicDescriptionCharacters
    InIPAExtensions
    InitialPunctuation
    InKanbun
    InKangxiRadicals
    InKannada
    InKatakana
    InKatakanaPhoneticExtensions
    InKhmer
    InLao
    InLatin1Supplement
    InLatinExtendedA
    InLatinExtendedAdditional
    InLatinExtendedB
    InLetterlikeSymbols
    InLowSurrogates
    InMalayalam
    InMathematicalAlphanumericSymbols
    InMathematicalOperators
    InMiscellaneousMathematicalSymbolsA
    InMiscellaneousMathematicalSymbolsB
    InMiscellaneousSymbols
    InMiscellaneousTechnical
    InMongolian
    InMusicalSymbols
    InMyanmar
    InNumberForms
    InOgham
    InOldItalic
    InOpticalCharacterRecognition
    InOriya
    InPrivateUseArea
    InRunic
    InSinhala
    InSmallFormVariants
    InSpacingModifierLetters
    InSpecials
    InSuperscriptsAndSubscripts
    InSupplementalArrowsA
    InSupplementalArrowsB
    InSupplementalMathematicalOperators
    InSupplementaryPrivateUseAreaA
    InSupplementaryPrivateUseAreaB
    InSyriac
    InTagalog
    InTagbanwa
    InTags
    InTamil
    InTelugu
    InThaana
    InThai
    InTibetan
    InUnifiedCanadianAboriginalSyllabics
    InVariationSelectors
    InYiRadicals
    InYiSyllables
    JoinControl
    Kannada
    Katakana
    Khmer
    L
    Lao
    Latin
    Letter
    LetterNumber
    LineSeparator
    Ll
    Lm
    Lo
    LogicalOrderException
    Lowercase
    LowercaseLetter
    Lr
    Lt
    Lu
    M
    Malayalam
    Mark
    Math
    MathSymbol
    Mc
    Me
    Mn
    ModifierLetter
    ModifierSymbol
    Mongolian
    Myanmar
    N
    Nd
    Nl
    No
    NoncharacterCodePoint
    NonspacingMark
    Number
    Ogham
    OldItalic
    OpenPunctuation
    Oriya
    Other
    OtherAlphabetic
    OtherDefaultIgnorableCodePoint
    OtherGraphemeExtend
    OtherLetter
    OtherLowercase
    OtherMath
    OtherNumber
    OtherPunctuation
    OtherSymbol
    OtherUppercase
    P
    ParagraphSeparator
    Pc
    Pd
    Pe
    Pf
    Pi
    Po
    Ps
    Punctuation
    QuotationMark
    Radical
    Runic
    S
    Sc
    Separator
    Sinhala
    Sk
    Sm
    So
    SoftDotted
    SpaceSeparator
    SpacingMark
    Symbol
    Syriac
    Tagalog
    Tagbanwa
    Tamil
    Telugu
    TerminalPunctuation
    Thaana
    Thai
    Tibetan
    TitlecaseLetter
    Unassigned
    UnifiedIdeograph
    Uppercase
    UppercaseLetter
    WhiteSpace
    Yi
    Z
    Zl
    Zp
    Zs
);

print qq{
    .namespace ['Regex';'Cursor']
    .sub '!uprop' :anon
        .param pmc self
        .param string uprop
        .local pmc cur
        .local int pos
        .local string tgt
        (cur, pos, tgt) = self.'!cursor_start'()
        \$I0 = x_is_uprop uprop, tgt, pos
        unless \$I0 goto fail
      pass:
        inc pos
        \$S0 = concat 'is', uprop
        cur.'!cursor_pass'(pos, \$S0)
      fail:
        .return (cur)
    .end
};

for (@prop) {
    print qq(
        .sub 'is$_' :method
            .tailcall '!uprop'(self, '$_')
        .end
    );
}
