# Announce: Rakudo Perl 6 compiler, Release #104 (2016.10)

On behalf of the Rakudo development team, I’m very happy to announce the
October 2016 release of Rakudo Perl 6 #104. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2016 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2016.10:
 + Fixes:
    + Many fixes and additions improving JVM backend support
    + Several improvements to error messages
    + Fixed .tree([&first]) incorrectly calling .tree($count) candidate
    + Fixed unwanted errors when smartmatching objects against IO::Path
    + Fixed is-deeply with Seqs showing Seq.new-consumed() in failure text
    + Fixed concurrency race when setting up NativeCall routines
    + Fixed Match.list treating inner unmatched captures as end of list
    + .first now correctly handles Junction matchers
    + Fixed GLOBAL symbol clash re-compiling due to a repo change
    + Fixed Backtrace.map candidate being uncallable
    + Fixed multiple bugs in Hash/Baggy.classify-list/categorize-list
    + Fixed PERL6_TEST_DIE_ON_FAIL not exiting on failed subtests
    + Fixed autovification using Junctions as keys
    + Fixed infix:<^^>(Mu, Callable) candidate being uncallable
    + Fixed IO.l for dangling symlinks
    + Fixed infinite recursion in duckmap when mapper returned Any
    + Fixed .subst/.subst-mutate treating incorrect arguments as failed matches
    + Fixed .subst-mutate not returning all matches with :x
    + Fixed hang on smartmatching Promises against numerics
    + Fixed failure to smartmatch Numeric:U against Numeric:D
    + Fixed hang on incorrect .splice arguments
    + Fixed hang on incorrect .split offset
    + Fixed multi-argument WhateverCode not detected in double closures
    + Fixed Baggy:U ~~ Baggy:D emitting gut-referencing warnings
    + Fixed uncallable Dateish.IO
    + Fixed Exceptions::JSON for exceptions with no `message` method
    + Fixed Exceptions::JSON for exceptions with non-JSON-friendly attributes
    + Proc::Async decoding exceptions are now catchable
    + Prevented return handler being optimized out in `sub { 42.return }()`
    + Fixed error reporting when trying to invoke a native parameter
    + Fixed uncallable 0- and 1-arg candidates of infix:<xx>
    + Fixed Cool.match not setting $/
    + Fixed Cool:U.IO coercion emitting internal warnings
    + Fixed Nil.chrs failing when called
    + Num:U++ now returns a Num zero instead of an Int one
 + Removals:
   + Removed argument-taking Dateish candidates for is-leap-year,
       days-in-month, and day-of-week [were never part of the spec]
   + Cool.IO no longer accepts any arguments
   + Overflow check has been removed from infix:<**>(int, int)
 + Additions:
    + Added basic Unicode 9 support (NFG changes for latest TR#29 still to do))
    + X::Proc::Unsuccessful now includes command that was run
    + IO::Handle.new now uses 'utf8' encoding by default
    + Bare `put` now requires parentheses to call as sub
    + .head/.tail with no arguments now return the item and not a 1-item List
    + Added basic native attribute parameter binding
    + Made nativecast and spurt multies
    + Added .^elems metamodel method to enums
    + Enums can now be used to declare array shapes
    + Added X::Invalid::ComputedValue exception
    + Throw when dereferencing a null pointer in NativeCall
    + It's now possible to refer to sigiless parameters inside `where` clauses
    + Added extra candidates to .splice to allow for all combinations of
        Int|Whatever|Callable for both $start and $elems arguments
    + Made enums able to typecheck against the roles they do
    + Made Complex.new() return 0+0i
    + Int.new can now handle any value that can .Int
    + Added shortname() method to CurriedRoleHOW
    + Proc::Async new, stdout, and stderr methods now take :enc
    + IO::Socket::Async listen, connect, and Supply methods now take :enc
    + .Date and .DateTime are now supported on :U/:D Date/DateTime
    + Trailing empty cells can now be omitted in Pod tables
    + Mix/MixHash with non-Int weights can now be coerced to .Bag/.BagHash
 + Efficiency:
    + Made List.reverse about 5% faster
    + Made auto-threading about 10% faster
    + Made huge improvement to CUR::Filesystem.id performance
    + Made dir() about 20% faster
    + Made Regex.Bool about 2x as fast
    + Made Str.match about 3% faster


The following people contributed to this release:

Zoffix Znet, Pawel Murias, Elizabeth Mattijsen, Wenzel P. P. Peppmeyer, 
Jonathan Worthington, Will "Coke" Coleda, Pepe Schwarz, 
Christian Bartolomäus, Tom Browder, Daniel Green, Jan-Olof Hendig, 
Jonathan Stowe, Luca Ferrari, Stefan Seifert, Tobias Leich, Itsuki Toyota, 
Moritz Lenz, Francis Grizzly Smit, Sterling Hanenkamp, Cuong Manh Le, 
Aleks-Daniel Jakimenko-Aleksejev, Alexis, Bart Wiegmans, Garrett Goebel, 
Brian S. Julin, David Warring, Salve J. Nilsen, Nic, Larry Wall, Altai-man, 
Timo Paulssen, cygx, raydiak, Dominique Dumont, dogbert17, Harrison Chienjo, 
LLFourn

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#105), is tentatively scheduled for 2016-11-19.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.

