### == TmplFiles.py - Generated File == ###
PyStub_glue_py = """
def __AIDA__open_namespace__ (name, _file):
  import sys, imp
  if sys.modules.has_key (name):
    return sys.modules[name]
  m = imp.new_module (name)
  m.__file__ = _file
  m.__doc__ = "AIDA IDL module %s (%s)" % (name, _file)
  sys.modules[m.__name__] = m
  return m

class __AIDA_Enum__ (long):
  def __new__ (_class, value, ident, doc = None):
    if ident and _class.enum_values.has_key (ident):
      raise KeyError (ident)
    instance = long.__new__ (_class, value)
    if ident: # track named enums (non-anonymous)
      instance.name = ident
      _class.enum_values[ident] = instance
      vlist = _class._valuedict.get (value, [])
      if not vlist:
        _class._valuedict[value] = vlist
      vlist += [ instance ]
    if doc:
      instance.__doc__ = doc
    return instance
  def __repr__ (self):
    if hasattr (self, 'name'):
      return '<enum %s.%s value %s>' % (self.__class__.__name__, self.name, repr (long (self)))
    else:
      return '<enum %s.%u>' % (self.__class__.__name__, self)
  def __str__ (self):
    return self.name if hasattr (self, 'name') else str (long (self))
  @classmethod
  def _enum_lookup (_class, value):
    try:
      return _class.index (value)
    except:
      return _class (value, None) # anonymous enum
  @classmethod
  def index (_class, value):
    return _class._valuedict[value][0]
  @classmethod
  def get (_class, key, default = None):
    return _class.enum_values.get (key, default)

class _BaseRecord_:
  def __init__ (self, **entries):
    self.__dict__.update (entries)

class _BaseClass_ (object):
  class _AidaID_:
    def __init__ (self, _aidaid):
      assert isinstance (_aidaid, (int, long))
      self.id = _aidaid
  class __Signal__:
    def __init__ (self, object, pyconnect):
      self.__object = object
      self.__pyconnect = pyconnect
    def connect (self, _callable):
      return self.__pyconnect (self.__object, _callable, 0)
    def disconnect (self, connection_id):
      return self.__pyconnect (self.__object, None, connection_id)
    def __iadd__ (self, _callable):
      return self.connect (_callable)
    def __isub__ (self, connection_id):
      return self.disconnect (connection_id)
  def __init__ (self, _aida_id):
    assert isinstance (_aida_id, _BaseClass_._AidaID_)
    self.__dict__['__aida_pyobject__'] = _aida_id.id
  def __getattr__ (self, name):
    try:
      getter = getattr (self.__class__, '__pygetter__%s__' % name)
    except AttributeError:
      try:
        getter = getattr (self.__class__, '__pysignal__%s__' % name)
      except AttributeError:
        raise AttributeError ("class %s has no attribute '%s'" % (self.__class__.__name__, name))
    return getter (self)
  def __setattr__ (self, name, value):
    try:
      setter = getattr (self.__class__, '__pysetter__%s__' % name)
    except AttributeError:
      try:
        getattr (self.__class__, '__pysignal__%s__' % name)
        return None # ignore setting of signals to allow __iadd__ and __isub__
      except AttributeError:
        raise AttributeError ("class %s has no attribute '%s'" % (self.__class__.__name__, name))
    return setter (self, value)

def __AIDA_pyfactory__create_pyobject__ (type_name, longid):
  def resolve (obj, path):
    parts = path.split ('.')
    parts.reverse()
    if parts:
      element = parts.pop()
      obj = obj[element]                # obj is a dict initially
    while parts:
      element = parts.pop()
      obj = getattr (obj, element)      # nested obj are module/object instances
    return obj
  try:
    klass = resolve (globals(), type_name)
  except:
    raise NameError ("undefined identifier '%s'" % type_name)
  if hasattr (klass, '_enum_lookup'):
    return klass._enum_lookup (longid)
  if not longid:
    return None
  if not klass:
    raise NameError ("undefined identifier '%s'" % type_name)
  return klass (_BaseClass_._AidaID_ (longid))
_CPY.__AIDA_pyfactory__register_callback (__AIDA_pyfactory__create_pyobject__)
_CPY.__AIDA_BaseRecord__ = _BaseRecord_
"""
PyStub_glue_cc = """
#include <Python.h> // must be included first to configure std headers
#include <string>

#include <rapicorn.hh>

#define None_INCREF()   ({ Py_INCREF (Py_None); Py_None; })
#define GOTO_ERROR()    goto error
#define ERRORif(cond)   if (cond) goto error
#define ERRORifpy()     if (PyErr_Occurred()) goto error
#define ERRORpy(msg)    do { PyErr_Format (PyExc_RuntimeError, msg); goto error; } while (0)
#define ERRORifnotret(fr) do { if (AIDA_UNLIKELY (!fr) || \\
                                   AIDA_UNLIKELY (!Rapicorn::Aida::msgid_is_result (Rapicorn::Aida::MessageId (fr->first_id())))) { \\
                                 PyErr_Format_from_AIDA_error (fr); \\
                                 goto error; } } while (0)
#define ERROR_callable_ifpy(callable) do { if (PyErr_Occurred()) { \\
  PyObject *t, *v, *tb; \\
  PyErr_Fetch (&t, &v, &tb); \\
  PyObject *sc = PyObject_Repr (callable), *sv = PyObject_Str (v); \\
  PyErr_Format (PyExceptionClass_Check (t) ? t : PyExc_RuntimeError, \\
                "in return from %s: %s", PyString_AsString (sc), PyString_AsString (sv)); \\
  Py_XDECREF (sc); Py_XDECREF (sv); Py_XDECREF (t); Py_XDECREF (v); Py_XDECREF (tb); \\
  goto error; \\
} } while (0)

#ifndef __AIDA_PYMODULE__OBJECT
#define __AIDA_PYMODULE__OBJECT ((PyObject*) NULL)
#endif

using Rapicorn::Aida::uint64;
using Rapicorn::Aida::FieldBuffer;
using Rapicorn::Aida::FieldReader;

// connection
static Rapicorn::Aida::ClientConnection *__AIDA_local__client_connection = NULL;

// connection initialization
static Rapicorn::Init __AIDA_init__client_connection ([]() {
  __AIDA_local__client_connection = Rapicorn::Aida::ObjectBroker::new_client_connection ($AIDA_pyclient_feature_keys$);
});

// helpers
static PyObject*
PyErr_Format_from_AIDA_error (const FieldBuffer *fr)
{
  if (!fr)
    return PyErr_Format (PyExc_RuntimeError, "Aida: missing return value");
  FieldReader frr (*fr);
  const uint64 msgid AIDA_UNUSED = frr.pop_int64();
  frr.skip(); frr.skip(); // hashhigh hashlow
#if 0
  if (Rapicorn::Aida::msgid_is_error (Rapicorn::Aida::MessageId (msgid)))
    {
      std::string msg = frr.pop_string(), domain = frr.pop_string();
      if (domain.size()) domain += ": ";
      msg = domain + msg;
      return PyErr_Format (PyExc_RuntimeError, "%s", msg.c_str());
    }
#endif
  return PyErr_Format (PyExc_RuntimeError, "Aida: garbage return: 0x%s", fr->first_id_str().c_str());
}

static inline PY_LONG_LONG
PyIntLong_AsLongLong (PyObject *intlong)
{
  if (PyInt_Check (intlong))
    return PyInt_AS_LONG (intlong);
  else
    return PyLong_AsLongLong (intlong);
}

static inline std::string
PyString_As_std_string (PyObject *pystr)
{
  char *s = NULL;
  Py_ssize_t len = 0;
  PyString_AsStringAndSize (pystr, &s, &len);
  return std::string (s, len);
}

static inline Rapicorn::Aida::uint64
PyAttr_As_uint64 (PyObject *pyobj, const char *attr_name)
{
  PyObject *pyo = PyObject_GetAttrString (pyobj, attr_name);
  Rapicorn::Aida::uint64 uval = pyo ? PyLong_AsUnsignedLongLong (pyo) : 0;
  Py_XDECREF (pyo);
  return uval;
}

static inline PyObject*
PyString_From_std_string (const std::string &s)
{
  return PyString_FromStringAndSize (s.data(), s.size());
}

static inline int
PyDict_Take_Item (PyObject *pydict, const char *key, PyObject **pyitemp)
{
  int r = PyDict_SetItemString (pydict, key, *pyitemp);
  if (r >= 0)
    {
      Py_DECREF (*pyitemp);
      *pyitemp = NULL;
    }
  return r;
}

static void
__AIDA_pyconvert__pyany_to_any (Rapicorn::Aida::Any &any, PyObject *pyvalue)
{
  if (pyvalue == Py_None)               any.retype (Rapicorn::Aida::TypeMap::notype());
  else if (PyString_Check (pyvalue))    any <<= PyString_As_std_string (pyvalue);
  else if (PyBool_Check (pyvalue))      any <<= bool (pyvalue == Py_True);
  else if (PyInt_Check (pyvalue))       any <<= PyInt_AS_LONG (pyvalue);
  else if (PyLong_Check (pyvalue))      any <<= PyLong_AsLongLong (pyvalue);
  else if (PyFloat_Check (pyvalue))     any <<= PyFloat_AsDouble (pyvalue);
  else {
    std::string msg =
      Rapicorn::string_format ("no known conversion to Aida::Any for Python object: %s", PyObject_REPR (pyvalue));
    PyErr_SetString (PyExc_NotImplementedError, msg.c_str());
  }
}

static PyObject*
__AIDA_pyconvert__pyany_from_any (const Rapicorn::Aida::Any &any)
{
  using namespace Rapicorn::Aida;
  switch (any.kind())
    {
    case UNTYPED:                               return None_INCREF();
    case BOOL:          { bool b; any >>= b;    return PyBool_FromLong (b); }
    case ENUM:  // chain
    case INT32: // chain
    case INT64:                                 return PyLong_FromLongLong (any.as_int());
    case FLOAT64:                               return PyFloat_FromDouble (any.as_float());
    case STRING:                                return PyString_From_std_string (any.as_string());
    case SEQUENCE:      break;
    case RECORD:        break;
    case INSTANCE:      break;
    case ANY:           break;
    default:            break;
    }
  std::string msg =
    Rapicorn::string_format ("no known conversion for Aida::%s to Python", Rapicorn::Aida::type_kind_name (any.kind()));
  PyErr_SetString (PyExc_NotImplementedError, msg.c_str());
  return NULL;
}

static PyObject *__AIDA_pyfactory__create_pyobject__ = NULL;

static PyObject*
__AIDA_pyfactory__register_callback (PyObject *pyself, PyObject *pyargs)
{
  if (__AIDA_pyfactory__create_pyobject__)
    return PyErr_Format (PyExc_RuntimeError, "object_factory_callable already registered");
  if (PyTuple_Size (pyargs) != 1)
    return PyErr_Format (PyExc_RuntimeError, "wrong number of arguments");
  PyObject *item = PyTuple_GET_ITEM (pyargs, 0);
  if (!PyCallable_Check (item))
    return PyErr_Format (PyExc_RuntimeError, "argument must be callable");
  Py_INCREF (item);
  __AIDA_pyfactory__create_pyobject__ = item;
  return None_INCREF();
}

static inline PyObject*
__AIDA_pyfactory__create_enum (const char *enum_name, uint64 enum_value)
{
  PyObject *result = NULL, *pyid;
  if (strchr (enum_name, ':'))
    goto unimplemented;
  if (!__AIDA_pyfactory__create_pyobject__)
    return PyErr_Format (PyExc_RuntimeError, "unregistered AIDA_pyfactory");
  pyid = PyLong_FromUnsignedLongLong (enum_value);
  if (pyid)
    {
      PyObject *tuple = PyTuple_New (2);
      if (tuple)
        {
          PyTuple_SET_ITEM (tuple, 0, PyString_FromString (enum_name));
          PyTuple_SET_ITEM (tuple, 1, pyid), pyid = NULL;
          result = PyObject_Call (__AIDA_pyfactory__create_pyobject__, tuple, NULL);
          Py_DECREF (tuple);
        }
      Py_XDECREF (pyid);
    }
  return result;
 unimplemented:
  Rapicorn::Aida::fatal_error (std::string() + "UNIMPLEMENTED: FIXME: missing handling of typenames outside the Rapicorn namespace: " + enum_name);
}

static inline PyObject*
__AIDA_pyfactory__create_from_orbid (uint64 orbid)
{
  PyObject *result = NULL, *pyid;
  const std::string fqtn = __AIDA_local__client_connection->type_name_from_orbid (orbid);
  std::string type_name = fqtn;
  size_t p = type_name.find ("::");
  while (p != std::string::npos)
    {
      type_name.replace (p, 2, ".");            // Foo::Bar::baz -> Foo.Bar.baz
      p = type_name.find ("::", p + 1);
    }
  if (!__AIDA_pyfactory__create_pyobject__)
    return PyErr_Format (PyExc_RuntimeError, "unregistered AIDA_pyfactory");
  pyid = PyLong_FromUnsignedLongLong (orbid);
  if (pyid)
    {
      PyObject *tuple = PyTuple_New (2);
      if (tuple)
        {
          PyTuple_SET_ITEM (tuple, 0, PyString_FromString (type_name.c_str()));
          PyTuple_SET_ITEM (tuple, 1, pyid), pyid = NULL;
          result = PyObject_Call (__AIDA_pyfactory__create_pyobject__, tuple, NULL);
          Py_DECREF (tuple);
        }
      Py_XDECREF (pyid);
    }
  return result;
}
"""
CxxStub_client_cc = """

#ifndef AIDA_CHECK
#define AIDA_CHECK(cond,errmsg) do { if (cond) break; throw std::runtime_error (std::string ("AIDA-ERROR: ") + errmsg); } while (0)
#endif

namespace { // Anon
using Rapicorn::Aida::uint64;

namespace __AIDA_Local__ {
using namespace Rapicorn::Aida;

// connection
static Rapicorn::Aida::ClientConnection *client_connection = NULL;
static Rapicorn::Init init_client_connection ([]() {
  client_connection = ObjectBroker::new_client_connection ($AIDA_client_feature_keys$);
});

// helper

static AIDA_UNUSED FieldBuffer*
invoke (FieldBuffer *fb)                // async remote call, transfers memory
{
  return client_connection->call_remote (fb);
}

static AIDA_UNUSED bool
signal_disconnect (size_t signal_handler_id)
{
  return client_connection->signal_disconnect (signal_handler_id);
}

static AIDA_UNUSED size_t
signal_connect (uint64 hhi, uint64 hlo, const SmartHandle &sh, SignalEmitHandler seh, void *data)
{
  return client_connection->signal_connect (hhi, hlo, sh._orbid(), seh, data);
}

static inline uint64
smh2id (const SmartHandle &sh)
{
  return sh._orbid();
}

template<class SMH> SMH
smh2cast (const SmartHandle &handle)
{
  const uint64 orbid = __AIDA_Local__::smh2id (handle);
  SMH target;
  struct Broker : ObjectBroker { using ObjectBroker::tie_handle; };
  Broker::tie_handle (target, orbid);
  return target;
}

static inline void
add_header2_call (FieldBuffer &fb, const SmartHandle &sh, uint64 h, uint64 l)
{
  fb.add_header2 (Rapicorn::Aida::MSGID_TWOWAY_CALL, ObjectBroker::connection_id_from_handle (sh),
                  client_connection->connection_id(), h, l);
}

static inline void
add_header1_call (FieldBuffer &fb, const SmartHandle &sh, uint64 h, uint64 l)
{
  fb.add_header1 (Rapicorn::Aida::MSGID_ONEWAY_CALL, ObjectBroker::connection_id_from_handle (sh), h, l);
}

static inline FieldBuffer*
new_emit_result (const FieldBuffer *fb, uint64 h, uint64 l, uint32 n)
{
  return ObjectBroker::renew_into_result (const_cast<FieldBuffer*> (fb),
                                          Rapicorn::Aida::MSGID_EMIT_RESULT,
                                          ObjectBroker::receiver_connection_id (fb->first_id()),
                                          h, l, n);
}

} } // Anon::__AIDA_Local__
"""
CxxStub_server_cc = """

#ifndef AIDA_CHECK
#define AIDA_CHECK(cond,errmsg) do { if (cond) break; throw std::runtime_error (std::string ("AIDA-ERROR: ") + errmsg); } while (0)
#endif

namespace { // Anon
using Rapicorn::Aida::uint64;

namespace __AIDA_Local__ {
using namespace Rapicorn::Aida;

// types
typedef ServerConnection::EmitResultHandler EmitResultHandler;
typedef ServerConnection::MethodRegistry    MethodRegistry;
typedef ServerConnection::MethodEntry       MethodEntry;

static_assert (std::is_base_of<Rapicorn::Aida::ImplicitBase, $AIDA_iface_base$>::value,
               "IDL interface base '$AIDA_iface_base$' must derive 'Rapicorn::Aida::ImplicitBase'");

// connection
static Rapicorn::Aida::ServerConnection *server_connection = NULL;
static Rapicorn::Init init_server_connection ([]() {
  server_connection = ObjectBroker::new_server_connection ($AIDA_server_feature_keys$);
});

// EmitResultHandler
static inline void erhandler_add (size_t id, const EmitResultHandler &function)
{
  return server_connection->emit_result_handler_add (id, function);
}

// objects
template<class Target> static inline Target* id2obj (uint64 oid)
{
  Rapicorn::Aida::ImplicitBase *instance = server_connection->orbid2instance (oid);
  return dynamic_cast<Target*> (instance);
}

static inline uint64 obj2id  (Rapicorn::Aida::ImplicitBase *obj)
{
  return server_connection->instance2orbid (obj);
}

template<class Object> static inline Object*
smh2obj (const SmartHandle &sh)
{
  return id2obj<Object> (sh._orbid());
}

template<class SMH> static inline SMH
obj2smh ($AIDA_iface_base$ *self)
{
  const uint64 orbid = obj2id (self);
  SMH target;
  struct Broker : ObjectBroker { using ObjectBroker::tie_handle; };
  Broker::tie_handle (target, orbid);
  return target;
}

// messages
static inline void
post_msg (FieldBuffer *fb)
{
  ObjectBroker::post_msg (fb);
}

static inline void
add_header1_discon (FieldBuffer &fb, size_t signal_handler_id, uint64 h, uint64 l)
{
  fb.add_header1 (Rapicorn::Aida::MSGID_DISCONNECT, ObjectBroker::connection_id_from_signal_handler_id (signal_handler_id), h, l);
}

static inline void
add_header1_emit (FieldBuffer &fb, size_t signal_handler_id, uint64 h, uint64 l)
{
  fb.add_header1 (Rapicorn::Aida::MSGID_EMIT_ONEWAY, ObjectBroker::connection_id_from_signal_handler_id (signal_handler_id), h, l);
}

static inline void
add_header2_emit (FieldBuffer &fb, size_t signal_handler_id, uint64 h, uint64 l)
{
  fb.add_header2 (Rapicorn::Aida::MSGID_EMIT_TWOWAY, ObjectBroker::connection_id_from_signal_handler_id (signal_handler_id),
                  server_connection->connection_id(), h, l);
}

static inline FieldBuffer*
new_call_result (FieldReader &fbr, uint64 h, uint64 l, uint32 n = 1)
{
  return ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_CALL_RESULT, ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), h, l, n);
}

static inline FieldBuffer*
new_connect_result (FieldReader &fbr, uint64 h, uint64 l, uint32 n = 1)
{
  return ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_CONNECT_RESULT, ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), h, l, n);
}

// slot
template<class SharedPtr, class R, class... Args> std::function<R (Args...)>
slot (SharedPtr sp, R (*fp) (const SharedPtr&, Args...))
{
  return [sp, fp] (Args... args) { return fp (sp, args...); };
}

} } // Anon::__AIDA_Local__
"""
