<?xml version="1.0" encoding="iso-8859-1"?>
<!--
	Name: $RCSfile: linkchecker.xsl,v $
	Author: Alan Moran
	$Date: 2005/11/20 13:36:27 $
	$Revision: 1.1 $
	$Id: linkchecker.xsl,v 1.1 2005/11/20 13:36:27 a_j_moran Exp $

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.
-->
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

  <xsl:output
    method="xml"
    version="1.0"
    indent="yes"
	omit-xml-declaration="yes"
    encoding="iso-8859-1"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" 
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
  />

<xsl:template match="/">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
    		<title>Link Checker Report</title>
			<style type="text/css">
				body { background-color: #FFFFFF; color : #333333; margin: 1em; font-family : Verdana, Arial, sans-serif; }
				tr.banner  { font-weight: bold; background-color: #006699; color: #FFFFFF } 
				tr.header  { font-weight: bold; }
				tr.oddRow  { background-color: #EEEEEE; }
				tr.evenRow { background-color: #DDDDDD; }
			</style>
		</head>
		<body  bgcolor="#FFFFFF">
			<xsl:apply-templates select="linkReport" />
		</body>
	</html>
</xsl:template>

<xsl:template match="linkReport">
	<h1>Link Check Report</h1>

	<table width="100%"  border="0" cellspacing="0" cellpadding="0">
		<xsl:apply-templates select="file" />
	</table>
</xsl:template>

<xsl:template match="file">
	<xsl:if test="count(error) &gt; 0">
		<tr class="banner">
			<td colspan="4">
				<xsl:value-of select="@name" />
			</td>
		</tr>
		<tr class="header">
			<td>Element</td>
			<td>Attribute</td>	
			<td>Line / Column</td>	
			<td>Broken Link</td>	
		</tr>
		<tr>
			<xsl:apply-templates select="error" />
		</tr>
	</xsl:if>
</xsl:template>


<xsl:template match="error">
	<xsl:variable name="class">
		<xsl:choose>
			<xsl:when test="position() mod 2 = 1">oddRow</xsl:when>
			<xsl:otherwise>evenRow</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<tr class="{$class}">
		<td>
			<xsl:value-of select="@element" />
		</td>
		<td>
			<xsl:value-of select="@attribute" />
		</td>	
		<td>
			<xsl:value-of select="@line" /> / <xsl:value-of select="@column" />
		</td>	
		<td>
			<xsl:value-of select="." />
		</td>	
	</tr>
</xsl:template>

</xsl:stylesheet>

