/*
   Name: $RCSfile: logger.h,v $
   Author: Alan Moran
   $Date: 2005/07/21 20:26:37 $
   $Revision: 1.7 $
   $Id: logger.h,v 1.7 2005/07/21 20:26:37 nloyola Exp $

   Description:
   Function prototypes and macros to support application logging.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_LOGGER_H
#define INCLUDE_LOGGER_H

BEGIN_C_DECLS

#define RPL_DEFAULT_LOGFILE "rapple.log"

enum RPL_LOG_LEVEL {
    RPL_LL_DEBUG = 1,
    RPL_LL_INFO,
    RPL_LL_WARN,
    RPL_LL_ERROR,
    RPL_LL_FATAL
};

void        rpl_log_fl_msg(rpl_str_t file, int line, rpl_str_t RPL_LOG_LEVEL, rpl_str_t msg);
/* experimental - do not use!
#define     rpl_log_msg(msg)    rpl_log_fl_msg(__FILE__, __LINE__, (msg))
*/

void        rpl_log_debug(rpl_c_str_t label);
void        rpl_log_info(rpl_c_str_t label);
void        rpl_log_warn(rpl_c_str_t label);
void        rpl_log_error(rpl_c_str_t label);
void        rpl_log_fatal(rpl_c_str_t label);

void        rpl_log_set_level(int s_llevel);
int         rpl_log_get_level();

rpl_str_t   rpl_log_get_level_desc(int query_level);
void        rpl_log_close_logfile(void);

END_C_DECLS

#endif
