/*
   Name: $RCSfile: webasset.h,v $
   Author: Alan Moran
   $Date: 2005/11/14 21:30:44 $
   $Revision: 1.9 $
   $Id: webasset.h,v 1.9 2005/11/14 21:30:44 a_j_moran Exp $

   Description:
   Data structures and prototypes for web assets.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_WEBASSET_H
#define INCLUDE_WEBASSET_H

BEGIN_C_DECLS

/**
   @file

   @brief Data structure and APIs for web assets.

 */

#include <time.h>

/* datastore internal structure (note absence of trailing "/" !) */
#define RPL_DS_TOUT_DIR "tout"
#define RPL_DS_TERR_DIR "terr"
#define RPL_DS_PARSE_DIR "parse"

extern rpl_list rpl_wa_registry;

typedef enum _rpl_wa_trf_status {
    RPL_WA_TRF_ST_SUCCESS = 0,
    RPL_WA_TRF_ST_WARNING,
    RPL_WA_TRF_ST_FAILURE,
    RPL_WA_TRF_ST_UNDEF
} rpl_wa_trf_status;

typedef struct _rpl_wa_trf_status_description {
    rpl_wa_trf_status  code;
    rpl_str_t    desc;
}
rpl_wa_trf_status_description;

extern const rpl_wa_trf_status_description trf_status[];
extern int trf_size;

/** This structure holds the information for a web asset. */
typedef struct _rpl_web_asset {
	/** unique key used for registry lookup purposes */
	rpl_str_t key;
    /** datastore data-time stamp */
    time_t      dts;
    /** contributor as identified by local process owner or HTTP basic authentication */
    rpl_str_t    contrib;
    /** filename to use if contents are to be stored to the filesystem */
    rpl_str_t    filename;
    /** directory relative to datastore subtree where file is be stored */
    rpl_str_t    rel_dir;
    /** MIME type assigned during upload */
    rpl_str_t    mime_type;
    /** tidy status code description */
    rpl_str_t    tidy_stat_desc;
    /** xslt status code description */
    rpl_str_t    tmpl_stat_desc;
}
rpl_web_asset;

void        rpl_wa_init(rpl_web_asset *wa);
void        rpl_wa_destroy(rpl_web_asset *wa);

void        rpl_wa_set_key(rpl_web_asset *wa);
void        rpl_wa_set_contributor(rpl_str_t contrib, rpl_web_asset *wa);
void        rpl_wa_set_filename(rpl_str_t filename, rpl_web_asset *wa);
void        rpl_wa_set_rel_dir(rpl_str_t build_int_dir, rpl_web_asset *wa);
void        rpl_wa_set_mime_type(rpl_str_t mime_type, rpl_web_asset *wa);
void 		rpl_wa_set_tidy_stat_desc(rpl_str_t desc, rpl_web_asset *wa);
void 		rpl_wa_set_tmpl_stat_desc(rpl_str_t desc, rpl_web_asset *wa);

rpl_str_t   rpl_wa_get_key(rpl_web_asset wa);
rpl_str_t   rpl_wa_get_contributor(rpl_web_asset wa);
rpl_str_t   rpl_wa_get_filename(rpl_web_asset wa);
rpl_str_t   rpl_wa_get_rel_dir(rpl_web_asset wa);
rpl_str_t   rpl_wa_get_mime_type(rpl_web_asset wa);
rpl_str_t   rpl_wa_get_tidy_stat_desc(rpl_web_asset wa);
rpl_str_t   rpl_wa_get_tmpl_stat_desc(rpl_web_asset wa);

int         rpl_wa_is_supported_mime_type(rpl_web_asset wa);
int         rpl_wa_is_transformable(rpl_web_asset wa);
rpl_str_t 	rpl_wa_get_trf_status_desc(unsigned int code);

END_C_DECLS

#endif

