/*
   Name: $RCSfile: workflow.h,v $
   Author: Alan Moran
   $Date: 2005/09/21 16:56:49 $
   $Revision: 1.2 $
   $Id: workflow.h,v 1.2 2005/09/21 16:56:49 a_j_moran Exp $

   Description:
   Function prototypes and macros to support workflow functionality.

   Legal Notice:

   This program is free software; you can redistribute it and/or
   modify it under the terms of the license contained in the
   COPYING file that comes with this distribution.

 */

#ifndef INCLUDE_WORKFLOW_H
#define INCLUDE_WORKFLOW_H

BEGIN_C_DECLS

#include <sys/types.h>
#include <sys/stat.h>

typedef enum _rpl_wk_status {
	RPL_WK_OK = 0,
	RPL_WK_WARN,
	RPL_WK_ERR
} rpl_wk_status;

typedef rpl_wk_status (* rpl_mod_init_fp)();
typedef rpl_wk_status (* rpl_mod_process_fp)(rpl_c_str_t filename, struct stat statbuf);
typedef rpl_wk_status (* rpl_mod_cleanup_fp)();
typedef void 		  (* rpl_mod_configure_fp)();

typedef struct _rpl_mod_fns {
	rpl_list_node 		node;
	rpl_mod_init_fp 	init;
	rpl_mod_process_fp 	process;
	rpl_mod_cleanup_fp 	cleanup;
	rpl_c_str_t  		basedir;
} rpl_mod_fns;

void 		rpl_wk_process(rpl_str_t domain, rpl_str_t srcdir, rpl_str_t webdir);

rpl_str_t 	rpl_wk_get_srcdir(void);
rpl_str_t 	rpl_wk_get_webdir(void);
rpl_str_t 	rpl_wk_get_domain(void);

END_C_DECLS

#endif

