# MyQueue.py
# Copyright (c) 2005 Alex Revo
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Import the required system modules.
import Queue
import threading
from types import *

# Import rbscrobbler modules.
from Debug import Debug
from singletonmixin import Singleton


class MyQueue(Debug, Singleton):
    __queue = None
    __event = None
    __lock  = None


    def __init__(self):
        # create new objects if they don't exist.
        if (not self.__queue):
            self.__queue = Queue.Queue(0)
        if (not self.__event):
            self.__event = threading.Event()
        if (not self.__lock):
            self.__lock = threading.RLock()

    def is_dirty(self):
        return(self.__event.isSet())
    def __make_dirty(self):
        return(self.__event.set())

    def clean(self):
        return(self.__event.clear())
    def get(self, block=True, timeout=None):
        self.__lock.acquire()
        try:
            ret = self.__queue.get(block, timeout)
        except Empty:
            ret = None
        self.__lock.release()
        return(ret)
    def put(self, item, block=True, timeout=None):
        """
        Add tuple (('name', 'value')) to queue; mark queue as dirty.
        """

        # sanity check input:
        if (type(item) is not TupleType):
            self.debug("MyQueue.put(): attempted to put() non-tuple.")
            return(None)
        if (len(item) != 2):
            self.debug("MyQueue.put(): tuple contains incorrect number of elements (%d); expected 2." % len(item))
            return(None)

        try:
            self.__lock.acquire()
            ret = self.__queue.put(item, block, timeout)
            self.__make_dirty()
            self.__lock.release()
        except Queue.Full, error:
            ret = None
        return(ret)


    def qsize(self):
        return(self.__queue.qsize())
    def wait(self, timeout=60):
        self.__event.wait(timeout)
