/******************************************************************************
*		       							      *
* engine/engine-private.h (part of rcalc)			       	      *
* Copyright (C) 2000,2001 Free Software Foundation, Inc.		      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

/* This lot is all earmarked for destruction when RcEngine/RcState is
** properly object-oriented.  We can get rid of all the hard-wired
** limits then as well!
*/

/*****************************************************************************/

/* Stuff that was in the old engine.h */

/* Observer functions for the commands, functions, constants and variables:
** used for tab complete, help and 'ls' commands.
*/
extern	int	 rCalc_engine_GetNumCommands( void );
extern	char	*rCalc_engine_GetCommandName( int i );
extern	char	*rCalc_engine_GetCommandHelp( int i );

extern	int	 rCalc_engine_GetNumFunctions( void );
extern	char	*rCalc_engine_GetFunctionName( int i );
extern  char    *rCalc_engine_GetFunctionExpr( int i );
extern	char	*rCalc_engine_GetFunctionHelp( int i );

extern	int	 rCalc_engine_GetNumConstants( void );
extern	char	*rCalc_engine_GetConstantName( int i );
extern	double 	 rCalc_engine_GetConstantValue( int i );
extern	char	*rCalc_engine_GetConstantHelp( int i );

#define rCalc_engine_GetNumVariables() 	 (cfgCalc->nVariables)
#define rCalc_engine_GetVariableName(i)  (cfgCalc->variables[(i)].name)
#define rCalc_engine_GetVariableValue(i) (cfgCalc->variables[(i)].value)

/* Deal with a line of user input: determine whether it is
** a command or an expression, and handle it accordingly.
*/
extern	int	 rCalc_engine_Execute( char *command );

/* Evaluate an expression, without command handling or locking.
*/
extern	void	 rCalc_engine_Evaluate( char *expression );

/* Initialise the calculation engine
*/
extern	void	 rCalc_engine_Initialise( void );
extern  void 	 rCalc_engine_setDefaultFunctions(RcEngine *engine);


/*****************************************************************************/

/* Stuff that was in the old config.h */

#define MAX_VARIABLE_NAME_LEN	31	/* Maximum length of a variable name */
#define MAX_VARIABLES		1024	/* Maximum number of variables	     */
#define MAX_FUNCTIONS           128 /* Maximum number of functions	     */
#define MAX_FUNC_EXPR_LEN       1024

#define NUM_DEFAULT_FUNCTIONS 19

#define RCALC_DOTDIR ".rcalc"

typedef struct
{
	char name[MAX_VARIABLE_NAME_LEN+1];
	double value;
}
VARIABLE;

typedef double (*tFunction) (double);

typedef struct
{
	char		name[MAX_VARIABLE_NAME_LEN+1];
        tFunction       func;
#ifdef USE_COMPILED_FUNCTIONS
		  GModule			*handle;
#else
        void            *handle;
#endif
        char            expression[MAX_FUNC_EXPR_LEN+1];
}
FUNCTION;

struct _RcEngine
{
	RcAngleUnit	angleMode;
	char		*func_var_name;
	VARIABLE	variables[MAX_VARIABLES];
   FUNCTION        functions[MAX_FUNCTIONS];
	int		nVariables;
   int             nFunctions;
};

extern RcEngine *cfgCalc;

struct _RcLastRes
{
	char		*name;
	char		*expr;
	char 		*value;
	char 		*error;
	char expType;
  gchar err_reason;
  gboolean replaced;
};

/*** end of engine/engine-private.h ******************************************/
