/******************************************************************************
*		       							      *
* engine/output.c (part of rcalc)				       	      *
* Copyright (C) 2000, 2001 Free Software Foundation, Inc.		      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <engine.h>

#include <stdio.h>
#include <stdarg.h>

#ifndef RCALC_TEXT_ONLY
 #include <gnome.h>
#else
 #include <glib.h>
 #include <libintl.h>
 #define _(String) gettext (String)
#endif

/*****************************************************************************/

#include "engine-private.h"	/* TODO: Remove */

/*****************************************************************************/

static RcLastRes lastRes;

void rc_init_impexp ( void )
{
  lastRes.name = NULL;
  lastRes.expr = NULL;
  lastRes.value = NULL;
  lastRes.error = NULL;
  lastRes.replaced = FALSE;
}

void rc_export_clear ( void )
{
  if (lastRes.name) { g_free(lastRes.name); lastRes.name = NULL;}
  if (lastRes.expr) { g_free(lastRes.expr); lastRes.expr = NULL;}
  if (lastRes.value) { g_free(lastRes.value); lastRes.value = NULL; }
  if (lastRes.error) {
    g_free(lastRes.error);
    lastRes.error = NULL;    
  }
  lastRes.replaced = FALSE; 
  lastRes.err_reason = RC_ERR_NO_ERROR;

}

void rc_export_error ( gchar reason, gchar *error )
{
  /*rc_export_clear();*/
  lastRes.error = g_strdup_printf("%s\n",error);
  lastRes.expType = RC_EXP_ERROR;
  lastRes.err_reason = reason;
}

void rc_export_value( gchar *name, gchar *expression, double value )
{  
  rc_export_clear();
  
  if (g_ascii_strncasecmp(name,"Ans",3)==0) {
    lastRes.name = g_strdup("");
    lastRes.expr = g_strdup(expression);
  }

  else {
  
    lastRes.name = g_strdup(name);
    lastRes.expr = g_strdup(expression);
  }

  lastRes.value = g_strdup_printf("%.16g", value);
  lastRes.expType = RC_EXP_VALUE;
}

void rc_export_function( gchar *name, gchar *expr )
{
  rc_export_clear();
  
  lastRes.name = g_strdup(name);
  lastRes.expr = g_strdup(expr);
  lastRes.value = g_strdup("");
  lastRes.expType = RC_EXP_FUNCTION;
}

void rc_export_replace_state(gboolean state)
{
  lastRes.replaced = state;
}

RcLastRes rc_import_lastres( void )
{
  return lastRes;
}

void rc_export_command( gchar *cmd )
{
  if (g_ascii_strncasecmp(cmd,"func",3)!=0) {
    lastRes.expType = RC_EXP_COMMAND;
  }  
}

gchar *rc_import_result_name( void )
{
  return lastRes.name;
}
gchar *rc_import_result_expr( void )
{
  return lastRes.expr;
}
gchar *rc_import_result_value( void )
{
  return lastRes.value;
}
gchar *rc_import_result_error( void )
{
  g_assert(lastRes.error);
  return lastRes.error;
}

gchar rc_import_result_type (void)
{
  return lastRes.expType;
}

gchar rc_import_err_reason (void)
{
  return lastRes.err_reason;
}

gboolean rc_import_replace_state( void )
{
  return lastRes.replaced;
}
