/******************************************************************************
*		       							      *
* engine/output.h (part of rcalc)				       	      *
* Copyright (C) 2001 Free Software Foundation, Inc.			      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

#ifndef __RC_IMPEXP_H__
#define __RC_IMPEXP_H__

enum {
  RC_EXP_VALUE,
  RC_EXP_FUNCTION,
  RC_EXP_COMMAND,
  RC_EXP_ERROR
};

enum {
  RC_ERR_NO_ERROR,
  RC_ERR_UNDEFINED,
  RC_ERR_OTHER
};

void rc_init_impexp ( void );

void rc_export_value( gchar *name, gchar *expression, double value );
void rc_export_function( gchar *name, gchar *expr);
void rc_export_command( gchar *cmd );
void rc_export_error( gchar reason, gchar *error );
void rc_export_replace_state( gboolean state );

gchar *rc_import_result_name( void );
gchar *rc_import_result_expr( void );
gchar *rc_import_result_value( void );
gchar *rc_import_result_error( void );
gchar rc_import_result_type( void );
gboolean rc_import_replace_state( void );

#endif /* __RC_IMPEXP_H__ */
