#ifndef __RCUI_H__
#define __RCUI_H__

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <bonobo.h>
#include <gnome.h>

#include "support.h"

#include "mainw_menus.h"
#include "mainw.h"
#include "varw.h"
#include "aboutw.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

enum
{
   NAME_COLUMN,
   EXPR_COLUMN,
   VALUE_COLUMN,
   RUN_COLUMN,
   INPUT_COLUMN,
   N_COLUMNS
};

enum
{
  RCUI_INSERT_END,
  RCUI_INSERT_BEFORE,
  RCUI_INSERT_AFTER,
  RCUI_REPLACE
};


typedef struct RCUI_params
{
  GtkTreeIter selected_iter;
  gboolean col_selected;
  gchar insert_mode;
  gchar *saveas;
  int angle_unit;
  
} RCUI_params;

typedef struct RCUI_stores
{
  GtkListStore *mainw_store;
  GtkListStore *varw_myv_store;
  GtkListStore *varw_myf_store;
  GtkListStore *varw_biv_store;
  GtkListStore *varw_bif_store;
  GtkListStore *history;
  
} RCUI_stores;

extern RCUI_params ui_params;
extern RCUI_stores ui_stores;

#include "rcui_lines.h"
#include "rcui_search.h"
#include "rcui_state_io.h"
#include "rcui_state.h"
#include "rcui_list.h"
#include "rcui_textbuf.h"

#endif
