/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSCLIENT_H
#define RDSCLIENT_H

#include <ClientProxy>
#include <QxtPimpl>
#include <QDateTime>
#include <AuthToken>
#include <rdsglobal.h>

class RdsClientPrivate;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RDS_CLIENT_EXPORT RdsClient : public QtRpc::ClientProxy
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsClient);
	QTRPC_CLIENTPROXY_PIMPL(RdsClient);
public:
	RdsClient(QObject *parent = 0);
	RdsClient(const RdsClient &other);
	~RdsClient();

	RdsClient &operator=(const RdsClient &other);
	/**
	 *        Sets the global RdsClient instance
	 * @param client The client to be the global instance
	 */
	static void setGlobalInstance(RdsClient *client);
	/**
	 *        Gets the RdsClient global instance
	 * @return a pointer to the global instance
	 */
	static RdsClient *globalInstance();
	virtual ReturnValue connect(QUrl url, QObject *obj, const char *slot, const QtRpc::AuthToken &auth);

	using QtRpc::ClientProxy::connect;

	QStringList serverProtocolVersions();
	QString serverProtocolVersion(RdsProtocol p);
	bool checkProtocolVersions();
	bool checkProtocolVersion(RdsProtocol p);

signals:
	ReturnValue isProvisioned();
	ReturnValue ldapSession();
	ReturnValue domainData();
	ReturnValue provisionator();
	ReturnValue status();
	ReturnValue dateTime();
	ReturnValue setDateTime(QObject *object, const char *slot, QDateTime now);
	ReturnValue setDateTime(QDateTime now);
	ReturnValue timeZone();
	ReturnValue setTimeZone(QObject *object, const char *slot, QString timezone);
	ReturnValue setTimeZone(QString timezone);
	ReturnValue listTimeZones();
	ReturnValue listLogs();
	ReturnValue shutdown();
	ReturnValue reboot();
	ReturnValue buildVersion();
	ReturnValue hostname();
	ReturnValue listInterfaces();

	// Do not use these signals
	void rdsAsyncronousSignaler(uint, ReturnValue);
	void rdsAsyncronousSignalerNamespace(uint, QtRpc::ReturnValue);
protected slots:
	void rdsConnectionCompleted(uint, ReturnValue);
};


inline RdsClient *rdsClient()
{
	return(RdsClient::globalInstance());
}

#endif
