/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsdnsmanager.h"
#include "rdsdnsmanager_p.h"

#include "RdsClient"

QTRPC_CLIENTPROXY_PIMPL_IMPLEMENT(RdsDnsManager);

RdsDnsManager::RdsDnsManager(QObject *parent)
	: RdsEntityManager(parent)
{
}

RdsDnsManager::RdsDnsManager(const RdsDnsManager &other)
	: RdsEntityManager(other)
{
}

RdsDnsManager::~RdsDnsManager()
{
}

RdsDnsManager& RdsDnsManager::operator=(const RdsDnsManager & other)
{
	RdsEntityManager::operator=(other);
	return *this;
}

ReturnValue RdsDnsManager::init()
{
	ReturnValue ret = rdsClient()->getService("DnsManager");
	if(ret.isError()) return(ret);
	
	*this = ret;
	return(true);
}


