/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSTORAGEDEVICE_H
#define RDSSTORAGEDEVICE_H

#include <ClientProxy>
#include <QxtPimpl>
#include <rdsglobal.h>

class RdsStorageDevicePrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RDS_CLIENT_EXPORT RdsStorageDevice : public QtRpc::ClientProxy
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsStorageDevice);
	QTRPC_CLIENTPROXY_PIMPL(RdsStorageDevice);
public:
	RdsStorageDevice(QObject *parent = 0);
	RdsStorageDevice(const RdsStorageDevice &mgr);
	~RdsStorageDevice();

	RdsStorageDevice &operator=(const RdsStorageDevice &mgr);

signals:
	ReturnValue path() const;
	ReturnValue listVolumes() const;
	ReturnValue initialize();
	ReturnValue initialize(QObject *object, const char *signal);
	ReturnValue initialize(bool partitionTable, const QString &fstype);
	ReturnValue initialize(QObject *object, const char *signal, bool partitionTable, const QString &fstype);
	ReturnValue isEjectable() const;
	ReturnValue eject();
	ReturnValue size() const;
	ReturnValue type() const; 
	ReturnValue name() const;
	ReturnValue serialNumber() const;
	ReturnValue model() const;
	ReturnValue inUse() const;

};

#endif
